/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers;

import house.greenhouse.rapscallionsandrockhoppers.RapscallionsAndRockhoppers;
import house.greenhouse.rapscallionsandrockhoppers.attachment.BoatLinksAttachment;
import house.greenhouse.rapscallionsandrockhoppers.attachment.PlayerLinksAttachment;
import house.greenhouse.rapscallionsandrockhoppers.entity.Penguin;
import house.greenhouse.rapscallionsandrockhoppers.entity.PenguinVariant;
import house.greenhouse.rapscallionsandrockhoppers.network.s2c.InvalidateCachedPenguinTypePacketS2C;
import house.greenhouse.rapscallionsandrockhoppers.network.s2c.SyncBlockPosLookPacketS2C;
import house.greenhouse.rapscallionsandrockhoppers.network.s2c.SyncBoatLinksAttachmentPacketS2C;
import house.greenhouse.rapscallionsandrockhoppers.network.s2c.SyncBoatPenguinsAttachmentPacketS2C;
import house.greenhouse.rapscallionsandrockhoppers.network.s2c.SyncPlayerLinksAttachmentPacketS2C;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersActivities;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersAttachments;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersBlockEntityTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersBlocks;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersDataComponents;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersEntityTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersItems;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMemoryModuleTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersMobEffects;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersPotions;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersSensorTypes;
import house.greenhouse.rapscallionsandrockhoppers.registry.RockhoppersSoundEvents;
import house.greenhouse.rapscallionsandrockhoppers.util.RockhoppersResourceKeys;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.logging.log4j.util.BiConsumer;

public class RapscallionsAndRockhoppersEvents {

    @EventBusSubscriber(modid="rapscallionsandrockhoppers", bus=EventBusSubscriber.Bus.GAME)
    public static class ForgeBusEvents {
        @SubscribeEvent
        public static void onServerStarted(ServerStartedEvent event) {
            RapscallionsAndRockhoppers.setBiomePopulationPenguinTypeRegistry(null);
        }

        @SubscribeEvent
        public static void onBoatInteraction(PlayerInteractEvent.EntityInteract event) {
            Entity entity = event.getTarget();
            if (entity instanceof Boat) {
                Boat boat = (Boat)entity;
                BoatLinksAttachment capability = RapscallionsAndRockhoppers.getHelper().getBoatData(boat);
                InteractionResult result = BoatLinksAttachment.handleInteractionWithBoatHook(boat, event.getEntity(), event.getHand());
                if (result != InteractionResult.PASS) {
                    event.setCancellationResult(result);
                    event.setCanceled(true);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Post event) {
            Optional attachment = event.getEntity().getExistingData(RockhoppersAttachments.PLAYER_LINKS);
            if (attachment.isPresent() && event.getEntity().tickCount % 20 == 0) {
                ((PlayerLinksAttachment)attachment.get()).invalidateNonExistentBoats(event.getEntity().level());
            }
        }

        @SubscribeEvent
        public static void onStartTracking(PlayerEvent.StartTracking event) {
            event.getTarget().getExistingData(RockhoppersAttachments.BOAT_LINKS).ifPresent(attachment -> PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new SyncBoatLinksAttachmentPacketS2C(event.getTarget().getId(), Optional.of(attachment)), (CustomPacketPayload[])new CustomPacketPayload[0]));
            event.getTarget().getExistingData(RockhoppersAttachments.PLAYER_LINKS).ifPresent(attachment -> PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new SyncPlayerLinksAttachmentPacketS2C(event.getTarget().getId(), Optional.of(attachment)), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }

        @SubscribeEvent
        public static void onRegisterBrewingRecipes(RegisterBrewingRecipesEvent event) {
            RockhoppersPotions.createRecipes(event.getBuilder());
        }
    }

    @EventBusSubscriber(modid="rapscallionsandrockhoppers", bus=EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerContent(RegisterEvent event) {
            if (event.getRegistryKey() == Registries.ENTITY_TYPE) {
                RockhoppersEntityTypes.registerEntityTypes();
            }
            if (event.getRegistryKey() == Registries.SOUND_EVENT) {
                RockhoppersSoundEvents.registerSoundEvents();
            }
            if (event.getRegistryKey() == Registries.ITEM) {
                RockhoppersItems.registerItems();
            }
            if (event.getRegistryKey() == Registries.BLOCK) {
                RockhoppersBlocks.registerBlocks();
            }
            if (event.getRegistryKey() == Registries.ACTIVITY) {
                RockhoppersActivities.registerActivities();
            }
            if (event.getRegistryKey() == Registries.MEMORY_MODULE_TYPE) {
                RockhoppersMemoryModuleTypes.registerMemoryModuleTypes();
            }
            if (event.getRegistryKey() == Registries.SENSOR_TYPE) {
                RockhoppersSensorTypes.registerSensorTypes();
            }
            if (event.getRegistryKey() == Registries.BLOCK_ENTITY_TYPE) {
                RockhoppersBlockEntityTypes.registerBlockEntityTypes();
            }
            if (event.getRegistryKey() == Registries.DATA_COMPONENT_TYPE) {
                RockhoppersDataComponents.registerDataComponents();
            }
            if (event.getRegistryKey() == Registries.MOB_EFFECT) {
                RockhoppersMobEffects.registerEffects();
            }
            if (event.getRegistryKey() == Registries.POTION) {
                RockhoppersPotions.registerPotions();
            }
        }

        @SubscribeEvent
        public static void createNewDataPackRegistries(DataPackRegistryEvent.NewRegistry event) {
            event.dataPackRegistry(RockhoppersResourceKeys.PENGUIN_VARIANT, PenguinVariant.DIRECT_CODEC, PenguinVariant.DIRECT_CODEC);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
            event.register(RockhoppersEntityTypes.PENGUIN, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Penguin::checkPenguinSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        }

        @SubscribeEvent
        public static void register(RegisterPayloadHandlersEvent event) {
            event.registrar("rapscallionsandrockhoppers").versioned("1.0.0").playToClient(InvalidateCachedPenguinTypePacketS2C.TYPE, InvalidateCachedPenguinTypePacketS2C.STREAM_CODEC, (payload, context) -> payload.handle()).playToClient(SyncBlockPosLookPacketS2C.TYPE, SyncBlockPosLookPacketS2C.STREAM_CODEC, (payload, context) -> payload.handle()).playToClient(SyncBoatLinksAttachmentPacketS2C.TYPE, SyncBoatLinksAttachmentPacketS2C.STREAM_CODEC, (payload, context) -> payload.handle()).playToClient(SyncPlayerLinksAttachmentPacketS2C.TYPE, SyncPlayerLinksAttachmentPacketS2C.STREAM_CODEC, (payload, context) -> payload.handle()).playToClient(SyncBoatPenguinsAttachmentPacketS2C.TYPE, SyncBoatPenguinsAttachmentPacketS2C.STREAM_CODEC, (payload, context) -> payload.handle());
        }

        @SubscribeEvent
        public static void createEntityAttributes(EntityAttributeCreationEvent event) {
            RockhoppersEntityTypes.createMobAttributes((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1));
        }

        @SubscribeEvent
        public static void onCreativeModeTabBuild(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
                RockhoppersItems.addAfterIngredientsTab((BiConsumer<ItemStack, ItemStack>)((BiConsumer)(stack, stack2) -> event.insertAfter(stack, stack2, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS)));
            } else if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
                RockhoppersItems.addBeforeToolsAndUtilitiesTab((BiConsumer<ItemStack, ItemStack>)((BiConsumer)(stack, stack2) -> event.insertAfter(stack, stack2, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS)));
            } else if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
                RockhoppersItems.addAfterNaturalBlocksTab((BiConsumer<ItemStack, ItemStack>)((BiConsumer)(stack, stack2) -> event.insertAfter(stack, stack2, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS)));
            } else if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
                RockhoppersItems.addSpawnEggsTab(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
            } else if (event.getTabKey() == CreativeModeTabs.BUILDING_BLOCKS) {
                RockhoppersItems.addAfterBuildingBlocksTab((BiConsumer<ItemStack, ItemStack>)((BiConsumer)(stack, stack2) -> event.insertAfter(stack, stack2, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS)));
            }
        }
    }
}

