/*
 * Decompiled with CFR 0.152.
 */
package house.greenhouse.rapscallionsandrockhoppers;

import com.mojang.datafixers.util.Pair;
import house.greenhouse.rapscallionsandrockhoppers.entity.PenguinVariant;
import house.greenhouse.rapscallionsandrockhoppers.platform.RockhoppersPlatformHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RapscallionsAndRockhoppers {
    public static final String MOD_ID = "rapscallionsandrockhoppers";
    public static final String MOD_NAME = "Rapscallions and Rockhoppers";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Rapscallions and Rockhoppers");
    private static RockhoppersPlatformHelper helper;
    private static final List<Pair<Integer, Integer>> PENGUIN_LOADED_CHUNKS;
    private static Registry<PenguinVariant> biomePopulationPenguinTypeRegistry;

    public static void init(RockhoppersPlatformHelper helper) {
        if (RapscallionsAndRockhoppers.helper != null) {
            return;
        }
        RapscallionsAndRockhoppers.helper = helper;
    }

    public static RockhoppersPlatformHelper getHelper() {
        return helper;
    }

    public static Registry<PenguinVariant> getBiomePopulationPenguinTypeRegistry() {
        return biomePopulationPenguinTypeRegistry;
    }

    @ApiStatus.Internal
    public static void setBiomePopulationPenguinTypeRegistry(WritableRegistry<PenguinVariant> value) {
        biomePopulationPenguinTypeRegistry = value;
    }

    public static void loadNearbyChunks(BlockPos pos, ServerLevel level) {
        int xCoord = SectionPos.blockToSectionCoord((int)pos.getX());
        int zCoord = SectionPos.blockToSectionCoord((int)pos.getZ());
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                int xSection = xCoord + x;
                int zSection = zCoord + z;
                if (level.getChunk(xSection, zSection, ChunkStatus.FULL, true) != null || PENGUIN_LOADED_CHUNKS.contains(Pair.of((Object)xSection, (Object)zSection))) continue;
                level.setChunkForced(xSection, zSection, true);
                PENGUIN_LOADED_CHUNKS.add((Pair<Integer, Integer>)Pair.of((Object)xSection, (Object)zSection));
            }
        }
    }

    public static void unloadChunks(ServerLevel level) {
        for (Pair<Integer, Integer> pair : PENGUIN_LOADED_CHUNKS) {
            level.setChunkForced(((Integer)pair.getFirst()).intValue(), ((Integer)pair.getSecond()).intValue(), false);
        }
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    static {
        PENGUIN_LOADED_CHUNKS = new ArrayList<Pair<Integer, Integer>>();
        biomePopulationPenguinTypeRegistry = null;
    }
}

