/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.lookup;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.lookup.HierarchyLookup;
import snownee.jade.impl.lookup.IHierarchyLookup;

public class WrappedHierarchyLookup<T extends IJadeProvider>
extends HierarchyLookup<T> {
    public final List<Pair<IHierarchyLookup<T>, Function<Accessor<?>, @Nullable Object>>> overrides = Lists.newArrayList();
    private boolean empty = true;

    public WrappedHierarchyLookup() {
        super(Object.class, true);
        this.overrides.add(Pair.of(new HierarchyLookup(Block.class, true), accessor -> {
            if (accessor instanceof BlockAccessor) {
                BlockAccessor blockAccessor = (BlockAccessor)accessor;
                return blockAccessor.getBlock();
            }
            return null;
        }));
    }

    public List<T> wrappedGet(Accessor<?> accessor) {
        ArrayList list = Lists.newArrayList();
        for (Pair<IHierarchyLookup<T>, Function<Accessor<?>, Object>> override : this.overrides) {
            Object o = ((Function)override.getRight()).apply(accessor);
            if (o == null) continue;
            list.addAll(((IHierarchyLookup)override.getLeft()).get(o));
        }
        list.addAll(this.get(accessor.getTarget()));
        return list;
    }

    public boolean hitsAny(Accessor<?> accessor, BiPredicate<T, Accessor<?>> predicate) {
        for (IJadeProvider provider : this.wrappedGet(accessor)) {
            if (!predicate.test(provider, accessor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void register(Class<?> clazz, T provider) {
        for (Pair<IHierarchyLookup<T>, Function<Accessor<?>, Object>> override : this.overrides) {
            if (!((IHierarchyLookup)override.getLeft()).isClassAcceptable(clazz)) continue;
            ((IHierarchyLookup)override.getLeft()).register(clazz, provider);
            this.empty = false;
            return;
        }
        super.register(clazz, provider);
        this.empty = false;
    }

    @Override
    public boolean isClassAcceptable(Class<?> clazz) {
        for (Pair<IHierarchyLookup<T>, Function<Accessor<?>, Object>> override : this.overrides) {
            if (!((IHierarchyLookup)override.getLeft()).isClassAcceptable(clazz)) continue;
            return true;
        }
        return super.isClassAcceptable(clazz);
    }

    @Override
    public void invalidate() {
        for (Pair<IHierarchyLookup<T>, Function<Accessor<?>, Object>> override : this.overrides) {
            ((IHierarchyLookup)override.getLeft()).invalidate();
        }
        super.invalidate();
    }

    @Override
    public void loadComplete(PriorityStore<ResourceLocation, IJadeProvider> priorityStore) {
        for (Pair<IHierarchyLookup<T>, Function<Accessor<?>, Object>> override : this.overrides) {
            ((IHierarchyLookup)override.getLeft()).loadComplete(priorityStore);
        }
        super.loadComplete(priorityStore);
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public Stream<Map.Entry<Class<?>, Collection<T>>> entries() {
        Stream stream = super.entries();
        for (Pair<IHierarchyLookup<T>, Function<Accessor<?>, Object>> override : this.overrides) {
            stream = Stream.concat(stream, ((IHierarchyLookup)override.getLeft()).entries());
        }
        return stream;
    }
}

