/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.client.screen.ActiveConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.EditStringScreen;
import com.mrcrayfish.configured.client.screen.IEditing;
import com.mrcrayfish.configured.client.screen.list.IListConfigValue;
import com.mrcrayfish.configured.client.screen.list.IListType;
import com.mrcrayfish.configured.client.screen.list.ListTypes;
import com.mrcrayfish.configured.client.screen.widget.ConfiguredButton;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;

public class EditListScreen<T>
extends Screen
implements IEditing {
    private final Screen parent;
    private final IModConfig config;
    private final List<StringHolder> initialValues = new ArrayList<StringHolder>();
    private final List<StringHolder> values = new ArrayList<StringHolder>();
    private final IConfigValue<List<T>> holder;
    private final IListType<T> listType;
    private ObjectList list;

    public EditListScreen(Screen parent, IModConfig config, Component titleIn, IConfigValue<List<T>> holder) {
        super(titleIn);
        this.parent = parent;
        this.config = config;
        this.holder = holder;
        this.listType = ListTypes.getType(holder);
        this.initialValues.addAll(holder.get().stream().map(o -> new StringHolder(this.listType.getStringParser().apply(o))).toList());
        this.values.addAll(this.initialValues);
    }

    protected void init() {
        boolean readOnly;
        this.list = new ObjectList();
        this.addWidget((GuiEventListener)this.list);
        if (!this.config.isReadOnly()) {
            this.addRenderableWidget((GuiEventListener)new IconButton(this.width / 2 - 140, this.height - 29, 0, 44, 90, (Component)Component.translatable((String)"configured.gui.apply"), button -> {
                List newValues = this.values.stream().map(StringHolder::getValue).map(s -> this.listType.getValueParser().apply((String)s)).collect(Collectors.toList());
                this.holder.set(newValues);
                this.minecraft.setScreen(this.parent);
            }));
            this.addRenderableWidget((GuiEventListener)new IconButton(this.width / 2 - 45, this.height - 29, 22, 33, 90, (Component)Component.translatable((String)"configured.gui.add_value"), button -> {
                String string;
                IConfigValue<List<T>> patt0$temp = this.holder;
                if (patt0$temp instanceof IListConfigValue) {
                    IListConfigValue listValue = (IListConfigValue)patt0$temp;
                    string = listValue.createPropertyValue();
                } else {
                    string = "";
                }
                String newValue = string;
                this.minecraft.setScreen((Screen)new EditStringScreen(this, this.config, (Component)Component.translatable((String)"configured.gui.edit_value"), newValue, s -> {
                    T value = this.listType.getValueParser().apply((String)s);
                    if (value != null) {
                        if (this.holder.isValid(Collections.singletonList(value))) {
                            return Pair.of((Object)true, (Object)CommonComponents.EMPTY);
                        }
                        return Pair.of((Object)false, (Object)this.holder.getValidationHint());
                    }
                    return Pair.of((Object)false, (Object)this.listType.getHint());
                }, s -> {
                    StringHolder holder = new StringHolder((String)s);
                    this.values.add(holder);
                    this.list.addEntry(new StringEntry(this.list, holder));
                }));
            }));
        }
        int cancelWidth = (readOnly = this.config.isReadOnly()) ? 150 : 90;
        int cancelOffset = readOnly ? -75 : 50;
        Component cancelLabel = readOnly ? Component.translatable((String)"configured.gui.close") : CommonComponents.GUI_CANCEL;
        this.addRenderableWidget((GuiEventListener)ScreenUtil.button(this.width / 2 + cancelOffset, this.height - 29, cancelWidth, 20, cancelLabel, button -> {
            if (this.isModified()) {
                ActiveConfirmationScreen confirmScreen = new ActiveConfirmationScreen(this, this.config, (Component)Component.translatable((String)"configured.gui.list_changed"), ConfirmationScreen.Icon.WARNING, result -> {
                    if (!result.booleanValue()) {
                        return true;
                    }
                    this.minecraft.setScreen(this.parent);
                    return false;
                });
                this.minecraft.setScreen((Screen)confirmScreen);
            } else {
                this.minecraft.setScreen(this.parent);
            }
        }));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.list.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 14, 0xFFFFFF);
    }

    @Override
    public IModConfig getActiveConfig() {
        return this.config;
    }

    public boolean isModified() {
        if (this.initialValues.size() != this.values.size()) {
            return true;
        }
        for (int i = 0; i < this.initialValues.size(); ++i) {
            String s2;
            String s1 = this.initialValues.get(i).getValue();
            if (s1.equals(s2 = this.values.get(i).getValue())) continue;
            return true;
        }
        return false;
    }

    public class ObjectList
    extends ContainerObjectSelectionList<StringEntry> {
        public ObjectList() {
            super(EditListScreen.this.minecraft, EditListScreen.this.width, EditListScreen.this.height - 36 - 36, 36, 24);
            EditListScreen.this.values.forEach(value -> this.addEntry(new StringEntry(this, (StringHolder)value)));
        }

        protected int getScrollbarPosition() {
            return this.width / 2 + 144;
        }

        public int getRowWidth() {
            return 260;
        }

        public int addEntry(StringEntry entry) {
            return super.addEntry((AbstractSelectionList.Entry)entry);
        }

        public boolean removeEntry(StringEntry entry) {
            return super.removeEntry((AbstractSelectionList.Entry)entry);
        }
    }

    public static class StringHolder {
        private String value;

        public StringHolder(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public class StringEntry
    extends ContainerObjectSelectionList.Entry<StringEntry> {
        private final StringHolder holder;
        private final ObjectList list;
        private final ConfiguredButton editButton;
        private final ConfiguredButton deleteButton;

        public StringEntry(ObjectList list, StringHolder holder) {
            this.list = list;
            this.holder = holder;
            this.editButton = new IconButton(0, 0, 1, 22, 20, CommonComponents.EMPTY, onPress -> EditListScreen.this.minecraft.setScreen((Screen)new EditStringScreen(EditListScreen.this, EditListScreen.this.config, (Component)Component.translatable((String)"configured.gui.edit_value"), this.holder.getValue(), s -> {
                Object value = EditListScreen.this.listType.getValueParser().apply((String)s);
                if (value != null) {
                    if (EditListScreen.this.holder.isValid(Collections.singletonList(value))) {
                        return Pair.of((Object)true, (Object)CommonComponents.EMPTY);
                    }
                    return Pair.of((Object)false, (Object)EditListScreen.this.holder.getValidationHint());
                }
                return Pair.of((Object)false, (Object)EditListScreen.this.listType.getHint());
            }, this.holder::setValue)));
            this.editButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"configured.gui.edit")), btn -> btn.isActive() && btn.isHoveredOrFocused());
            this.editButton.active = !EditListScreen.this.config.isReadOnly();
            this.deleteButton = new IconButton(0, 0, 11, 0, onPress -> {
                EditListScreen.this.values.remove(this.holder);
                this.list.removeEntry(this);
            });
            this.deleteButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"configured.gui.remove")), btn -> btn.isActive() && btn.isHoveredOrFocused());
            this.deleteButton.active = !EditListScreen.this.config.isReadOnly();
        }

        public void render(GuiGraphics graphics, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (x % 2 != 0) {
                graphics.fill(left, top, left + width, top + 24, 0x55000000);
            }
            graphics.drawString(((EditListScreen)EditListScreen.this).minecraft.font, (Component)Component.literal((String)this.holder.getValue()), left + 5, top + 8, 0xFFFFFF);
            this.editButton.visible = true;
            this.editButton.setX(left + width - 44);
            this.editButton.setY(top + 2);
            this.editButton.render(graphics, mouseX, mouseY, partialTicks);
            this.deleteButton.visible = true;
            this.deleteButton.setX(left + width - 22);
            this.deleteButton.setY(top + 2);
            this.deleteButton.render(graphics, mouseX, mouseY, partialTicks);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)((Object)this.editButton), (Object)((Object)this.deleteButton));
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void updateNarration(NarrationElementOutput output) {
                    output.add(NarratedElementType.TITLE, StringEntry.this.holder.getValue());
                }
            }, (Object)((Object)this.editButton), (Object)((Object)this.deleteButton));
        }
    }
}

