/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.create_jetpack.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.possible_triangle.create_jetpack.config.Configs;
import com.possible_triangle.flightlib.api.ControlType;
import com.possible_triangle.flightlib.api.FlightKey;
import com.possible_triangle.flightlib.api.IFlightApi;
import com.possible_triangle.flightlib.api.IJetpack;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R&\u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/possible_triangle/create_jetpack/client/ControlsDisplay;", "Lnet/minecraft/client/gui/LayeredDraw$Layer;", "<init>", "()V", "controls", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "Lnet/minecraft/resources/ResourceLocation;", "airIndicator", "spritePos", "Lnet/minecraft/world/phys/Vec2;", "index", "", "ICONS", "", "Lcom/possible_triangle/flightlib/api/FlightKey;", "Lkotlin/Function1;", "Lcom/possible_triangle/flightlib/api/IJetpack$Context;", "Lcom/possible_triangle/flightlib/api/ControlType;", "register", "", "event", "Lnet/neoforged/neoforge/client/event/RegisterGuiLayersEvent;", "render", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "tracker", "Lnet/minecraft/client/DeltaTracker;", "create_jetpack-forge-5.1.0"})
@SourceDebugExtension(value={"SMAP\nControlsDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlsDisplay.kt\ncom/possible_triangle/create_jetpack/client/ControlsDisplay\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1#2:133\n490#3,7:134\n506#3,7:141\n1573#4:148\n1604#4,4:149\n*S KotlinDebug\n*F\n+ 1 ControlsDisplay.kt\ncom/possible_triangle/create_jetpack/client/ControlsDisplay\n*L\n78#1:134,7\n79#1:141,7\n80#1:148\n80#1:149,4\n*E\n"})
public final class ControlsDisplay
implements LayeredDraw.Layer {
    @NotNull
    public static final ControlsDisplay INSTANCE = new ControlsDisplay();
    private static final ResourceLocation controls = ResourceLocation.fromNamespaceAndPath((String)"create_jetpack", (String)"textures/gui/controls.png");
    private static final ResourceLocation airIndicator = ResourceLocation.fromNamespaceAndPath((String)"create_jetpack", (String)"textures/gui/air_indicator.png");
    @NotNull
    private static final Map<FlightKey, Function1<IJetpack.Context, ControlType>> ICONS;

    private ControlsDisplay() {
    }

    private final Vec2 spritePos(int index) {
        return new Vec2((float)(index % 2) * 16.0f, (float)(index / 2) * 16.0f);
    }

    public final void register(@NotNull RegisterGuiLayersEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.registerAbove(VanillaGuiLayers.HOTBAR, ResourceLocation.fromNamespaceAndPath((String)"create_jetpack", (String)"jetpack_controls"), (LayeredDraw.Layer)this);
    }

    /*
     * WARNING - void declaration
     */
    public void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker tracker) {
        void $this$mapIndexedTo$iv$iv;
        void $this$filterValues$iv;
        Integer n;
        Integer n2;
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Minecraft mc = Minecraft.getInstance();
        if (!((Boolean)Configs.INSTANCE.getCLIENT().getSHOW_OVERLAY().get()).booleanValue()) {
            return;
        }
        if (mc.options.hideGui) {
            return;
        }
        LocalPlayer localPlayer = mc.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        IJetpack.Context context = IFlightApi.Companion.getINSTANCE().findJetpack((LivingEntity)player);
        if (context == null) {
            return;
        }
        IJetpack.Context context2 = context;
        int margin = 6;
        float scale = (float)((Number)Configs.INSTANCE.getCLIENT().getOVERLAY_DISTANCE_SCALE().get()).doubleValue();
        int spriteWidth = 16 + margin;
        Integer it = (Integer)Configs.INSTANCE.getCLIENT().getOVERLAY_DISTANCE_X().get();
        boolean bl = false;
        if (it >= 0) {
            n2 = it;
        } else {
            int n3 = graphics.guiWidth();
            Intrinsics.checkNotNull((Object)it);
            n2 = n3 + it - 50;
        }
        it = n2;
        boolean bl2 = false;
        int startX = (int)((float)it.intValue() / scale);
        Integer it2 = (Integer)Configs.INSTANCE.getCLIENT().getOVERLAY_DISTANCE_Y().get();
        boolean bl3 = false;
        if (it2 >= 0) {
            n = it2;
        } else {
            int n4 = graphics.guiHeight();
            Intrinsics.checkNotNull((Object)it2);
            n = n4 + it2 - 24;
        }
        Integer it3 = n;
        boolean bl4 = false;
        int startY = (int)((float)it3.intValue() / scale);
        boolean engineActive = FlightKey.TOGGLE_ACTIVE.isPressed((LivingEntity)player);
        Map $this$filterKeys$iv = ICONS;
        boolean $i$f$filterKeys = false;
        Object result$iv = new LinkedHashMap<FlightKey, Function1<IJetpack.Context, ControlType>>();
        for (Map.Entry<FlightKey, Function1<IJetpack.Context, ControlType>> entry : $this$filterKeys$iv.entrySet()) {
            FlightKey it32 = entry.getKey();
            boolean bl5 = false;
            if (!(it32 == FlightKey.TOGGLE_ACTIVE || engineActive)) continue;
            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
        }
        $this$filterKeys$iv = (Map)result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry<Object, Object> entry : $this$filterValues$iv.entrySet()) {
            Function1 getType = (Function1)entry.getValue();
            boolean bl6 = false;
            if (!(getType.invoke((Object)context2) == ControlType.TOGGLE)) continue;
            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
        }
        Iterable $this$mapIndexed$iv = ((Map)result$iv).keySet();
        boolean $i$f$mapIndexed = false;
        result$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean bl5 = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void key;
            int n5;
            if ((n5 = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FlightKey flightKey = (FlightKey)item$iv$iv;
            int n6 = n5;
            Collection collection = destination$iv$iv;
            boolean bl7 = false;
            graphics.pose().pushPose();
            boolean active = key.isPressed((LivingEntity)player);
            ControlsDisplay.render$renderSprite(graphics, scale, startX, startY, (int)(index + (active ? 0 : 2)), spriteWidth * index);
            float textScale = 0.5f;
            graphics.pose().scale(textScale, textScale, textScale);
            float textMargin = (float)(startX + 8 + spriteWidth * index) * (1.0f / textScale);
            String string = key.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            MutableComponent text = Component.translatable((String)("overlay.flightlib.control." + string));
            int color = active ? 0xFFFFFF : 0xBBBBBB;
            graphics.drawCenteredString(mc.font, (Component)text, (int)textMargin, startY * 2 + 36, color);
            graphics.pose().popPose();
            collection.add(Unit.INSTANCE);
        }
        int renderedIcons = ((Collection)((List)destination$iv$iv)).size();
        if (engineActive) {
            graphics.pose().pushPose();
            graphics.pose().scale(scale, scale, scale);
            RenderSystem.enableBlend();
            int barWidth = 5;
            boolean blink = player.level().getGameTime() % (long)20 < 5L;
            List list = BacktankUtil.getAllWithAir((LivingEntity)((LivingEntity)player));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllWithAir(...)");
            ItemStack itemStack = (ItemStack)CollectionsKt.firstOrNull((List)list);
            if (itemStack == null) {
                itemStack = ItemStack.EMPTY;
            }
            ItemStack airSource = itemStack;
            int maxAir = BacktankUtil.maxAir((ItemStack)airSource);
            int n7 = BacktankUtil.getAir((ItemStack)airSource);
            int barHeight = (int)Math.ceil((double)n7 * 14.0 / (double)maxAir);
            boolean shrinking = context2.getJetpack().isThrusting(context2);
            ControlsDisplay.render$renderBar$default(graphics, startX, spriteWidth, renderedIcons, startY, barWidth, 1, 0, 0, 384, null);
            if (shrinking && barHeight > 0 && blink) {
                ControlsDisplay.render$renderBar(graphics, startX, spriteWidth, renderedIcons, startY, barWidth, 0, barHeight - 1, 1);
            } else {
                ControlsDisplay.render$renderBar(graphics, startX, spriteWidth, renderedIcons, startY, barWidth, 0, barHeight, 1);
            }
            RenderSystem.disableBlend();
            graphics.pose().popPose();
        }
    }

    private static final ControlType ICONS$lambda$0(IJetpack.Context it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getJetpack().activeType(it);
    }

    private static final ControlType ICONS$lambda$1(IJetpack.Context it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getJetpack().hoverType(it);
    }

    private static final void render$renderSprite(GuiGraphics $graphics, float scale, int startX, int startY, int index, int x) {
        Vec2 sprite = INSTANCE.spritePos(index);
        $graphics.pose().scale(scale, scale, scale);
        $graphics.blit(controls, startX + x, startY, 0, sprite.x, sprite.y, 16, 16, 32, 32);
    }

    private static final void render$renderBar(GuiGraphics $graphics, int startX, int spriteWidth, int renderedIcons, int startY, int barWidth, int index, int barHeight, int spriteOffset) {
        $graphics.blit(airIndicator, startX + spriteWidth * renderedIcons, startY + (19 - barHeight) - spriteOffset, (float)(barWidth * index), 16.0f - (float)barHeight - (float)spriteOffset, barWidth, barHeight, 16, 16);
    }

    static /* synthetic */ void render$renderBar$default(GuiGraphics guiGraphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Object object) {
        if ((n9 & 0x80) != 0) {
            n7 = 16;
        }
        if ((n9 & 0x100) != 0) {
            n8 = 0;
        }
        ControlsDisplay.render$renderBar(guiGraphics, n, n2, n3, n4, n5, n6, n7, n8);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)FlightKey.TOGGLE_ACTIVE, ControlsDisplay::ICONS$lambda$0), TuplesKt.to((Object)FlightKey.TOGGLE_HOVER, ControlsDisplay::ICONS$lambda$1)};
        ICONS = MapsKt.mapOf((Pair[])pairArray);
    }
}

