/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.ElevatedCornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.ElevatedSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.InnerCornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.CompoundSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
public final class ElevatedSlopeSlabSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            return switch (type) {
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstElevatedSlopeSlab(dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstSlopeSlab(dir, top, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstCompoundSlopeSlab(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(dir, top, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER -> ElevatedSlopeSlabSkipPredicate.testAgainstFlatElevatedInnerSlopeSlabCorner(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> ElevatedSlopeSlabSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W -> ElevatedSlopeSlabSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, top, adjState, side);
                case BlockType.FRAMED_SLOPE_EDGE -> ElevatedSlopeSlabSkipPredicate.testAgainstSlopeEdge(dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_EDGE -> ElevatedSlopeSlabSkipPredicate.testAgainstElevatedSlopeEdge(dir, top, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE -> ElevatedSlopeSlabSkipPredicate.testAgainstInnerCornerSlopeEdge(dir, top, adjState, side);
                case BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE -> ElevatedSlopeSlabSkipPredicate.testAgainstElevatedCornerSlopeEdge(dir, top, adjState, side);
                case BlockType.FRAMED_SLAB -> ElevatedSlopeSlabSkipPredicate.testAgainstSlab(dir, top, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> ElevatedSlopeSlabSkipPredicate.testAgainstSlabEdge(dir, top, adjState, side);
                case BlockType.FRAMED_STAIRS -> ElevatedSlopeSlabSkipPredicate.testAgainstStairs(dir, top, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS, BlockType.FRAMED_VERTICAL_HALF_SLOPE -> ElevatedSlopeSlabSkipPredicate.testAgainstVerticalHalfStairs(dir, top, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> ElevatedSlopeSlabSkipPredicate.testAgainstSlopedStairs(dir, top, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        if (ElevatedSlopeSlabSkipPredicate.getTriDir(dir, top, side).isEqualTo(ElevatedSlopeSlabSkipPredicate.getTriDir(adjDir, adjTop, side.getOpposite()))) {
            return true;
        }
        return ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(ElevatedSlopeSlabSkipPredicate.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstSlopeSlab(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlopeSlabSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_SLAB})
    private static boolean testAgainstCompoundSlopeSlab(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(CompoundSlopeSlabSkipPredicate.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInnerSlopeSlabCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        if (ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(FlatElevatedSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTop, side.getOpposite()))) {
            return true;
        }
        return ElevatedSlopeSlabSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatElevatedSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedInnerSlopeSlabCorner(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return ElevatedSlopeSlabSkipPredicate.getTriDir(dir, top, side).isEqualTo(FlatElevatedInnerSlopeSlabCornerSkipPredicate.getTriDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return ElevatedSlopeSlabSkipPredicate.getTriDir(dir, top, side).isEqualTo(ExtendedCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerCornerSlopePanelWall(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return ElevatedSlopeSlabSkipPredicate.getTriDir(dir, top, side).isEqualTo(ExtendedInnerCornerSlopePanelWallSkipPredicate.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_EDGE})
    private static boolean testAgainstSlopeEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlopeEdgeSkipPredicate.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_EDGE})
    private static boolean testAgainstElevatedSlopeEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        return ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(ElevatedSlopeEdgeSkipPredicate.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerCornerSlopeEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(InnerCornerSlopeEdgeSkipPredicate.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedCornerSlopeEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(ElevatedCornerSlopeEdgeSkipPredicate.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB})
    private static boolean testAgainstSlab(Direction dir, boolean top, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlabSkipPredicate.getHalfDir(adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        StairsShape adjShape = (StairsShape)adjState.getValue((Property)BlockStateProperties.STAIRS_SHAPE);
        Half adjHalf = (Half)adjState.getValue((Property)BlockStateProperties.HALF);
        return ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS, BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(VerticalHalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(Direction dir, boolean top, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return ElevatedSlopeSlabSkipPredicate.getHalfDir(dir, top, side).isEqualTo(SlopedStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    public static HalfTriangleDir getTriDir(Direction dir, boolean top, Direction side) {
        if (side.getAxis() == dir.getClockWise().getAxis()) {
            Direction longEdge = top ? Direction.UP : Direction.DOWN;
            return HalfTriangleDir.fromDirections(longEdge, dir, false);
        }
        return HalfTriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, boolean top, Direction side) {
        if (side == dir.getOpposite()) {
            return HalfDir.fromDirections(side, top ? Direction.UP : Direction.DOWN);
        }
        return HalfDir.NULL;
    }
}

