/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeedge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.QuarterTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.TriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pillar.ThreewayCornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.MasonryCornerSegmentSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.HalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slope.VerticalHalfSlopeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.CornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.ElevatedCornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.ElevatedInnerCornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.ElevatedSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.InnerThreewayCornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.ThreewayCornerSlopeEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.CompoundSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.ExtendedSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.ExtendedInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeInnerCornerSlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.LargeInnerCornerSlopePanelWallSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.CompoundSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.ElevatedSlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatElevatedSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.FlatInnerSlopeSlabCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.SlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalHalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

@CullTest(value={BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE})
public final class InnerCornerSlopeEdgeSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
            boolean alt = (Boolean)state.getValue((Property)PropertyHolder.ALT_TYPE);
            return switch (blockType) {
                case BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstInnerCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstElevatedSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstElevatedCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstElevatedInnerCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_THREEWAY_CORNER_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstThreewayCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_INNER_THREEWAY_CORNER_SLOPE_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstInnerThreewayCornerSlopeEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLAB -> InnerCornerSlopeEdgeSkipPredicate.testAgainstSlab(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstSlabEdge(dir, type, alt, adjState, side);
                case BlockType.FRAMED_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstPanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> InnerCornerSlopeEdgeSkipPredicate.testAgainstCornerPillar(dir, type, alt, adjState, side);
                case BlockType.FRAMED_STAIRS -> InnerCornerSlopeEdgeSkipPredicate.testAgainstStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> InnerCornerSlopeEdgeSkipPredicate.testAgainstVerticalStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> InnerCornerSlopeEdgeSkipPredicate.testAgainstHalfStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> InnerCornerSlopeEdgeSkipPredicate.testAgainstSlopeSlab(dir, type, alt, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> InnerCornerSlopeEdgeSkipPredicate.testAgainstElevatedSlopeSlab(dir, type, alt, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_SLAB -> InnerCornerSlopeEdgeSkipPredicate.testAgainstCompoundSlopeSlab(dir, type, alt, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> InnerCornerSlopeEdgeSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, type, alt, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> InnerCornerSlopeEdgeSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(dir, type, alt, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> InnerCornerSlopeEdgeSkipPredicate.testAgainstVerticalHalfStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstExtendedSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstCompoundSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> InnerCornerSlopeEdgeSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, type, alt, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> InnerCornerSlopeEdgeSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, type, alt, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstLargeCornerSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W -> InnerCornerSlopeEdgeSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, type, alt, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W -> InnerCornerSlopeEdgeSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, type, alt, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL -> InnerCornerSlopeEdgeSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, type, alt, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W -> InnerCornerSlopeEdgeSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, type, alt, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstHalfSlope(dir, type, alt, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> InnerCornerSlopeEdgeSkipPredicate.testAgainstSlopedStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> InnerCornerSlopeEdgeSkipPredicate.testAgainstVerticalHalfSlope(dir, type, alt, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> InnerCornerSlopeEdgeSkipPredicate.testAgainstVerticalSlopedStairs(dir, type, alt, adjState, side);
                case BlockType.FRAMED_THREEWAY_CORNER_PILLAR -> InnerCornerSlopeEdgeSkipPredicate.testAgainstThreewayCornerPillar(dir, type, alt, adjState, side);
                case BlockType.FRAMED_MASONRY_CORNER_SEGMENT -> InnerCornerSlopeEdgeSkipPredicate.testAgainstMasonryCornerSegment(dir, type, alt, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return InnerCornerSlopeEdgeSkipPredicate.getTriDir(dir, type, alt, side).isEqualTo(InnerCornerSlopeEdgeSkipPredicate.getTriDir(adjDir, adjType, adjAlt, side.getOpposite())) || InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(InnerCornerSlopeEdgeSkipPredicate.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite())) || InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(InnerCornerSlopeEdgeSkipPredicate.getStairDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return InnerCornerSlopeEdgeSkipPredicate.getTriDir(dir, type, alt, side).isEqualTo(CornerSlopeEdgeSkipPredicate.getTriDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_EDGE})
    private static boolean testAgainstSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return InnerCornerSlopeEdgeSkipPredicate.getTriDir(dir, type, alt, side).isEqualTo(SlopeEdgeSkipPredicate.getTriDir(adjDir, adjType, adjAlt, side.getOpposite())) || InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(SlopeEdgeSkipPredicate.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_EDGE})
    private static boolean testAgainstElevatedSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(ElevatedSlopeEdgeSkipPredicate.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(ElevatedCornerSlopeEdgeSkipPredicate.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedInnerCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(ElevatedInnerCornerSlopeEdgeSkipPredicate.getStairDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER_SLOPE_EDGE})
    private static boolean testAgainstThreewayCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return InnerCornerSlopeEdgeSkipPredicate.getTriDir(dir, type, alt, side).isEqualTo(ThreewayCornerSlopeEdgeSkipPredicate.getTriDir(adjDir, adjTop, adjRight, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_THREEWAY_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerThreewayCornerSlopeEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return InnerCornerSlopeEdgeSkipPredicate.getTriDir(dir, type, alt, side).isEqualTo(InnerThreewayCornerSlopeEdgeSkipPredicate.getTriDir(adjDir, adjTop, adjRight, adjAlt, side.getOpposite())) || InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(InnerThreewayCornerSlopeEdgeSkipPredicate.getStairDir(adjDir, adjTop, adjRight, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB})
    private static boolean testAgainstSlab(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(SlabSkipPredicate.getHalfDir(adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PANEL})
    private static boolean testAgainstPanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstCornerPillar(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        StairsShape adjShape = (StairsShape)adjState.getValue((Property)BlockStateProperties.STAIRS_SHAPE);
        Half adjHalf = (Half)adjState.getValue((Property)BlockStateProperties.HALF);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.getOpposite())) || InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(StairsSkipPredicate.getStairDir(adjDir, adjShape, adjHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.getValue(PropertyHolder.STAIRS_TYPE));
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.getOpposite())) || InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(VerticalStairsSkipPredicate.getStairDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.getOpposite())) || InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(HalfStairsSkipPredicate.getStairDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstSlopeSlab(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(SlopeSlabSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(ElevatedSlopeSlabSkipPredicate.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_SLAB})
    private static boolean testAgainstCompoundSlopeSlab(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(CompoundSlopeSlabSkipPredicate.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInnerSlopeSlabCorner(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(FlatInnerSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(FlatElevatedSlopeSlabCornerSkipPredicate.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(VerticalHalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.getOpposite())) || InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(VerticalHalfStairsSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXTENDED_SLOPE_PANEL})
    private static boolean testAgainstExtendedSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_PANEL})
    private static boolean testAgainstCompoundSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(CompoundSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedSlopePanelCorner(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeCornerSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(LargeCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeCornerSlopePanelWall(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(LargeCornerSlopePanelWallSkipPredicate.getStairDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeInnerCornerSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(LargeInnerCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeInnerCornerSlopePanelWall(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(LargeInnerCornerSlopePanelWallSkipPredicate.getStairDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerCornerSlopePanel(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(ExtendedInnerCornerSlopePanelSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerCornerSlopePanelWall(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(ExtendedInnerCornerSlopePanelWallSkipPredicate.getStairDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfSlope(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(HalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(SlopedStairsSkipPredicate.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfSlope(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(VerticalHalfSlopeSkipPredicate.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER_PILLAR})
    private static boolean testAgainstThreewayCornerPillar(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(ThreewayCornerPillarSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_MASONRY_CORNER_SEGMENT})
    private static boolean testAgainstMasonryCornerSegment(Direction dir, CornerType type, boolean alt, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return InnerCornerSlopeEdgeSkipPredicate.getHalfDir(dir, type, alt, side).isEqualTo(MasonryCornerSegmentSkipPredicate.getHalfDir(adjDir, adjTop, side.getOpposite())) || InnerCornerSlopeEdgeSkipPredicate.getStairDir(dir, type, alt, side).isEqualTo(MasonryCornerSegmentSkipPredicate.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    public static QuarterTriangleDir getTriDir(Direction dir, CornerType type, boolean alt, Direction side) {
        if (type.isHorizontal()) {
            Direction frontTwo;
            Direction frontOne = type.isTop() ? Direction.DOWN : Direction.UP;
            Direction direction = frontTwo = type.isRight() ? dir.getCounterClockWise() : dir.getClockWise();
            if (side == frontOne) {
                return QuarterTriangleDir.fromDirections(dir, frontTwo.getOpposite(), alt);
            }
            if (side == frontTwo) {
                return QuarterTriangleDir.fromDirections(dir, frontOne.getOpposite(), alt);
            }
        } else {
            Direction bottom;
            Direction direction = bottom = type.isTop() ? Direction.UP : Direction.DOWN;
            if (side == dir.getOpposite()) {
                return QuarterTriangleDir.fromDirections(bottom, dir.getCounterClockWise(), alt);
            }
            if (side == dir.getClockWise()) {
                return QuarterTriangleDir.fromDirections(bottom, dir, alt);
            }
        }
        return QuarterTriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, CornerType type, boolean alt, Direction side) {
        if (!alt) {
            if (type.isHorizontal()) {
                Direction backTwo;
                Direction backOne = type.isTop() ? Direction.UP : Direction.DOWN;
                Direction direction = backTwo = type.isRight() ? dir.getClockWise() : dir.getCounterClockWise();
                if (side == backOne || side == backTwo) {
                    return HalfDir.fromDirections(side, dir);
                }
            } else {
                Direction bottom;
                Direction direction = bottom = type.isTop() ? Direction.UP : Direction.DOWN;
                if (side == dir || side == dir.getCounterClockWise()) {
                    return HalfDir.fromDirections(side, bottom);
                }
            }
        }
        return HalfDir.NULL;
    }

    public static TriangleDir getStairDir(Direction dir, CornerType type, boolean alt, Direction side) {
        if (!alt) {
            if (type.isHorizontal()) {
                if (side == dir) {
                    Direction backOne = type.isTop() ? Direction.UP : Direction.DOWN;
                    Direction backTwo = type.isRight() ? dir.getClockWise() : dir.getCounterClockWise();
                    return TriangleDir.fromDirections(backOne, backTwo);
                }
            } else {
                Direction bottom;
                Direction direction = bottom = type.isTop() ? Direction.UP : Direction.DOWN;
                if (side == bottom) {
                    return TriangleDir.fromDirections(dir, dir.getCounterClockWise());
                }
            }
        }
        return TriangleDir.NULL;
    }
}

