/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanel;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.blockentity.doubled.slopepanel.FramedDoubleSlopePanelBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.NullCullPredicate;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedDoubleSlopePanelBlock
extends AbstractFramedDoubleBlock {
    public static final NullCullPredicate NULL_CULL_PREDICATE = new NullCullPredicate(state -> (Boolean)state.getValue((Property)PropertyHolder.FRONT) == false, state -> (Boolean)state.getValue((Property)PropertyHolder.FRONT));

    public FramedDoubleSlopePanelBlock() {
        super(BlockType.FRAMED_DOUBLE_SLOPE_PANEL);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, PropertyHolder.FRONT, BlockStateProperties.WATERLOGGED, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return FramedSlopePanelBlock.getStateForPlacement(this, context);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        if (face.getAxis() == dir.getAxis()) {
            HorizontalRotation blockRot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            return (BlockState)state.setValue(PropertyHolder.ROTATION, (Comparable)((Object)blockRot.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        if (rot != Rotation.NONE) {
            return (BlockState)state.cycle((Property)PropertyHolder.FRONT);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return FramedSlopePanelBlock.mirrorPanel(state, mirror);
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
        boolean front = (Boolean)state.getValue((Property)PropertyHolder.FRONT);
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        BlockState defState = ((Block)FBContent.BLOCK_FRAMED_SLOPE_PANEL.value()).defaultBlockState();
        return new Tuple((Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing)).setValue(PropertyHolder.ROTATION, (Comparable)((Object)rotation))).setValue((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(front))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((BlockState)((BlockState)defState.setValue((Property)FramedProperties.FACING_HOR, (Comparable)facing.getOpposite())).setValue(PropertyHolder.ROTATION, (Comparable)((Object)(rotation.isVertical() ? rotation.getOpposite() : rotation)))).setValue((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(!front))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        return switch ((HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION))) {
            default -> throw new MatchException(null, null);
            case HorizontalRotation.LEFT, HorizontalRotation.RIGHT -> DoubleBlockTopInteractionMode.EITHER;
            case HorizontalRotation.UP -> DoubleBlockTopInteractionMode.SECOND;
            case HorizontalRotation.DOWN -> DoubleBlockTopInteractionMode.FIRST;
        };
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean front = (Boolean)state.getValue((Property)PropertyHolder.FRONT);
        if (side == facing) {
            return front ? CamoGetter.NONE : CamoGetter.FIRST;
        }
        if (side == facing.getOpposite()) {
            return front ? CamoGetter.SECOND : CamoGetter.NONE;
        }
        if (!front && edge == facing || front && edge == facing.getOpposite()) {
            HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            Direction orientation = rot.withFacing(facing);
            Direction perpOrientation = rot.rotate(Rotation.CLOCKWISE_90).withFacing(facing);
            if (side == orientation || side.getAxis() == perpOrientation.getAxis() && front) {
                return CamoGetter.SECOND;
            }
            if (side == orientation.getOpposite() || side.getAxis() == perpOrientation.getAxis()) {
                return CamoGetter.FIRST;
            }
        }
        return CamoGetter.NONE;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        Direction facing = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        boolean front = (Boolean)state.getValue((Property)PropertyHolder.FRONT);
        if (!front && side == facing) {
            return SolidityCheck.FIRST;
        }
        if (front && side == facing.getOpposite()) {
            return SolidityCheck.SECOND;
        }
        return SolidityCheck.NONE;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedDoubleSlopePanelBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        return this.defaultBlockState();
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

