/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.event.ClientTickEvent;

public final class ClientTaskQueue {
    private static final List<ClientTask> tasks = new ArrayList<ClientTask>();
    private static ResourceKey<Level> lastDimension = null;

    public static void enqueueClientTask(long delay, Runnable task) {
        if (delay == 0L) {
            Minecraft.getInstance().tell(task);
            return;
        }
        long time = Minecraft.getInstance().level.getGameTime() + delay;
        tasks.add(new ClientTask(time, task));
    }

    public static void onClientTick(ClientTickEvent.Post event) {
        if (tasks.isEmpty()) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || level.dimension() != lastDimension) {
            lastDimension = level != null ? level.dimension() : null;
            tasks.clear();
            if (level == null) {
                return;
            }
        }
        Iterator<ClientTask> it = tasks.iterator();
        while (it.hasNext()) {
            ClientTask task = it.next();
            if (level.getGameTime() < task.time) continue;
            task.task.run();
            it.remove();
        }
    }

    private ClientTaskQueue() {
    }

    private record ClientTask(long time, Runnable task) {
    }
}

