/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.special;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import xfacthd.framedblocks.api.ghost.GhostRenderBehaviour;
import xfacthd.framedblocks.api.ghost.RegisterGhostRenderBehavioursEvent;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.util.CamoList;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.render.util.GhostVertexConsumer;
import xfacthd.framedblocks.common.config.ClientConfig;

public final class GhostBlockRenderer {
    private static final RandomSource RANDOM = RandomSource.create();
    private static final Map<Item, GhostRenderBehaviour> RENDER_BEHAVIOURS = new IdentityHashMap<Item, GhostRenderBehaviour>();
    private static final GhostRenderBehaviour DEFAULT_BEHAVIOUR = new GhostRenderBehaviour(){};
    private static final String PROFILER_KEY = "framedblocks_ghost_block";
    private static final float SCALE = 1.0001f;

    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (!ClientConfig.VIEW.showGhostBlocks() || event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        ProfilerFiller profiler = GhostBlockRenderer.mc().getProfiler();
        profiler.push(PROFILER_KEY);
        try {
            GhostBlockRenderer.tryDrawGhostBlock(event.getPoseStack(), profiler);
        }
        catch (Throwable t) {
            CrashReport report = CrashReport.forThrowable((Throwable)t, (String)"FramedBlocks: Rendering placement preview");
            CrashReportCategory category = report.addCategory("Placement preview context");
            GhostBlockRenderer.mc().player.fillCrashReportCategory(category);
            category.setDetail("Rotation", (Object)Float.valueOf(GhostBlockRenderer.mc().player.getYRot()));
            category.setDetail("Direction", (Object)GhostBlockRenderer.mc().player.getDirection());
            category.setDetail("Held item", (Object)Utils.formatItemStack(GhostBlockRenderer.mc().player.getMainHandItem()));
            category.setDetail("Level", (Object)GhostBlockRenderer.mc().level);
            category.setDetail("Hit result", (Object)Utils.formatHitResult(GhostBlockRenderer.mc().hitResult));
            category.trimStacktrace(category.getStacktrace().length);
            throw new ReportedException(report);
        }
        profiler.pop();
    }

    private static void tryDrawGhostBlock(PoseStack poseStack, ProfilerFiller profiler) {
        BlockHitResult hit;
        if (GhostBlockRenderer.mc().player.isSpectator()) {
            return;
        }
        HitResult hitResult = GhostBlockRenderer.mc().hitResult;
        if (!(hitResult instanceof BlockHitResult) || (hit = (BlockHitResult)hitResult).getType() != HitResult.Type.BLOCK) {
            return;
        }
        ItemStack stack = GhostBlockRenderer.mc().player.getMainHandItem();
        if (stack.isEmpty()) {
            return;
        }
        GhostRenderBehaviour behaviour = RENDER_BEHAVIOURS.getOrDefault(stack.getItem(), DEFAULT_BEHAVIOUR);
        profiler.push("get_stack");
        ItemStack proxiedStack = behaviour.getProxiedStack(stack);
        profiler.pop();
        profiler.push("may_render");
        if (!behaviour.mayRender(stack, proxiedStack)) {
            profiler.pop();
            return;
        }
        profiler.pop();
        profiler.push("make_context");
        BlockPlaceContext context = new BlockPlaceContext((Player)GhostBlockRenderer.mc().player, InteractionHand.MAIN_HAND, stack, hit);
        BlockState hitState = GhostBlockRenderer.mc().level.getBlockState(hit.getBlockPos());
        profiler.pop();
        int passCount = behaviour.getPassCount(stack, proxiedStack);
        for (int pass = 0; pass < passCount && GhostBlockRenderer.drawGhostBlock(poseStack, profiler, behaviour, stack, proxiedStack, hit, context, hitState, pass); ++pass) {
        }
    }

    private static boolean drawGhostBlock(PoseStack poseStack, ProfilerFiller profiler, GhostRenderBehaviour behaviour, ItemStack stack, ItemStack proxiedStack, BlockHitResult hit, BlockPlaceContext context, BlockState hitState, int renderPass) {
        profiler.push("get_state");
        BlockState renderState = behaviour.getRenderState(stack, proxiedStack, hit, context, hitState, renderPass);
        profiler.pop();
        if (renderState == null) {
            return true;
        }
        profiler.push("get_pos");
        BlockPos renderPos = behaviour.getRenderPos(stack, proxiedStack, hit, context, hitState, context.getClickedPos(), renderPass);
        profiler.popPush("can_render");
        if (renderPass == 0 && !behaviour.canRenderAt(stack, proxiedStack, hit, context, hitState, renderState, renderPos)) {
            profiler.pop();
            return false;
        }
        profiler.pop();
        profiler.push("get_camo");
        CamoList camo = behaviour.readCamo(stack, proxiedStack, renderPass);
        camo = behaviour.postProcessCamo(stack, proxiedStack, context, renderState, renderPass, camo);
        profiler.popPush("build_modeldata");
        ModelData modelData = behaviour.buildModelData(stack, proxiedStack, context, renderState, renderPass, camo);
        profiler.pop();
        profiler.push("append_modeldata");
        modelData = behaviour.appendModelData(stack, proxiedStack, context, renderState, renderPass, modelData);
        profiler.pop();
        MultiBufferSource.BufferSource buffers = GhostBlockRenderer.mc().renderBuffers().bufferSource();
        GhostBlockRenderer.doRenderGhostBlock(poseStack, buffers, profiler, renderPos, renderState, modelData);
        return true;
    }

    private static void doRenderGhostBlock(PoseStack poseStack, MultiBufferSource.BufferSource buffers, ProfilerFiller profiler, BlockPos renderPos, BlockState renderState, ModelData modelData) {
        RenderType bufferType = ClientConfig.VIEW.useAltGhostRenderer() ? Sheets.translucentCullBlockSheet() : NeoForgeRenderTypes.TRANSLUCENT_ON_PARTICLES_TARGET.get();
        int opacity = ClientConfig.VIEW.getGhostRenderOpacity();
        profiler.push("buffer");
        Vec3 offset = Vec3.atLowerCornerOf((Vec3i)renderPos).subtract(GhostBlockRenderer.mc().gameRenderer.getMainCamera().getPosition());
        GhostVertexConsumer builder = new GhostVertexConsumer(buffers.getBuffer(bufferType), opacity);
        profiler.pop();
        profiler.push("draw");
        BakedModel model = ModelUtils.getModel(renderState);
        poseStack.pushPose();
        poseStack.translate(offset.x + 0.5, offset.y + 0.5, offset.z + 0.5);
        poseStack.scale(1.0001f, 1.0001f, 1.0001f);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        for (RenderType type : model.getRenderTypes(renderState, RANDOM, modelData)) {
            GhostBlockRenderer.doRenderGhostBlockInLayer(poseStack, (VertexConsumer)builder, renderPos, renderState, type, modelData);
        }
        poseStack.popPose();
        profiler.pop();
        profiler.push("upload");
        RenderSystem.enableCull();
        buffers.endBatch(bufferType);
        profiler.pop();
    }

    private static void doRenderGhostBlockInLayer(PoseStack poseStack, VertexConsumer builder, BlockPos renderPos, BlockState renderState, RenderType layer, ModelData modelData) {
        GhostBlockRenderer.mc().getBlockRenderer().renderBatched(renderState, renderPos, (BlockAndTintGetter)GhostBlockRenderer.mc().level, poseStack, builder, false, RANDOM, modelData, layer);
    }

    public static void init() {
        ModLoader.postEvent((Event)new RegisterGhostRenderBehavioursEvent((behaviour, blocks) -> {
            Preconditions.checkNotNull((Object)behaviour, (Object)"GhostRenderBehaviour must be non-null");
            Preconditions.checkArgument((((Block[])blocks).length > 0 ? 1 : 0) != 0, (Object)"At least one block must be provided to register a GhostRenderBehaviour");
            for (Block block : blocks) {
                Item item = block.asItem();
                Preconditions.checkState((boolean)(item instanceof BlockItem), (String)"Block %s must have an associated BlockItem", (Object)block);
                RENDER_BEHAVIOURS.put(item, (GhostRenderBehaviour)behaviour);
            }
        }, (behaviour, items) -> {
            Preconditions.checkNotNull((Object)behaviour, (Object)"GhostRenderBehaviour must be non-null");
            Preconditions.checkArgument((((Item[])items).length > 0 ? 1 : 0) != 0, (Object)"At least one item must be provided to register a GhostRenderBehaviour");
            for (Item item : items) {
                Preconditions.checkNotNull((Object)item);
                RENDER_BEHAVIOURS.put(item, (GhostRenderBehaviour)behaviour);
            }
        }));
    }

    public static GhostRenderBehaviour getBehaviour(Item item) {
        return RENDER_BEHAVIOURS.getOrDefault(item, DEFAULT_BEHAVIOUR);
    }

    private static Minecraft mc() {
        return Minecraft.getInstance();
    }

    private GhostBlockRenderer() {
    }
}

