/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.data.outline;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import xfacthd.framedblocks.api.render.OutlineRenderer;
import xfacthd.framedblocks.api.render.Quaternions;

public final class PyramidOutlineRenderer
implements OutlineRenderer {
    private static final Quaternionf[] XN_DIR = PyramidOutlineRenderer.makeQuaternionArray();
    private final float height;

    public PyramidOutlineRenderer(boolean slab) {
        this.height = slab ? 0.5f : 1.0f;
    }

    @Override
    public void draw(BlockState state, PoseStack pstack, VertexConsumer builder) {
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        OutlineRenderer.drawLine(builder, pstack, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 0.0f, 0.5f, this.height, 0.5f);
        OutlineRenderer.drawLine(builder, pstack, 1.0f, 0.0f, 0.0f, 0.5f, this.height, 0.5f);
        OutlineRenderer.drawLine(builder, pstack, 0.0f, 0.0f, 1.0f, 0.5f, this.height, 0.5f);
        OutlineRenderer.drawLine(builder, pstack, 1.0f, 0.0f, 1.0f, 0.5f, this.height, 0.5f);
    }

    @Override
    public void rotateMatrix(PoseStack poseStack, BlockState state) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        if (dir == Direction.DOWN) {
            poseStack.mulPose(Quaternions.ZP_180);
        } else if (dir != Direction.UP) {
            poseStack.mulPose(Quaternions.ZP_90);
            poseStack.mulPose(XN_DIR[dir.get2DDataValue()]);
        }
    }

    private static Quaternionf[] makeQuaternionArray() {
        Quaternionf[] array = new Quaternionf[4];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            array[dir.get2DDataValue()] = Axis.XN.rotationDegrees(dir.toYRot() - 90.0f);
        }
        return array;
    }
}

