/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model.quad;

import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import xfacthd.framedblocks.api.model.quad.QuadModifier;

public final class MultiQuadModifier {
    private final QuadModifier modOne;
    private final QuadModifier modTwo;

    public MultiQuadModifier(QuadModifier modOne, QuadModifier modTwo) {
        this.modOne = modOne;
        this.modTwo = modTwo;
    }

    public MultiQuadModifier applyIf(QuadModifier.Modifier modifier, boolean apply) {
        this.modOne.applyIf(modifier, apply);
        this.modTwo.applyIf(modifier, apply);
        return this;
    }

    public MultiQuadModifier apply(QuadModifier.Modifier modifier) {
        this.modOne.apply(modifier);
        this.modTwo.apply(modifier);
        return this;
    }

    public MultiQuadModifier tintIndex(int tintIndex) {
        this.modOne.tintIndex(tintIndex);
        this.modTwo.tintIndex(tintIndex);
        return this;
    }

    public MultiQuadModifier shade(boolean shade) {
        this.modOne.shade(shade);
        this.modTwo.shade(shade);
        return this;
    }

    public MultiQuadModifier ambientOcclusion(boolean ao) {
        this.modOne.ambientOcclusion(ao);
        this.modTwo.ambientOcclusion(ao);
        return this;
    }

    public void export(List<BakedQuad> quadList) {
        this.modOne.export(quadList);
        this.modTwo.export(quadList);
    }

    public void modifyInPlace() {
        this.modOne.modifyInPlace();
        this.modTwo.modifyInPlace();
    }

    public MultiQuadModifier derive() {
        return new MultiQuadModifier(this.modOne.derive(), this.modTwo.derive());
    }
}

