/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.armorstatushud.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class HUDUtils {
    public static void renderItemOverlayIntoGUI(GuiGraphics graphics, Font font, ItemStack stack, int x, int y, boolean showDamageBar, boolean showCount) {
        if (!stack.isEmpty() && (showDamageBar || showCount)) {
            if (stack.isDamaged() && showDamageBar) {
                int barWidth = stack.getBarWidth();
                int barColor = stack.getBarColor();
                RenderSystem.disableDepthTest();
                RenderSystem.disableCull();
                RenderSystem.disableBlend();
                HUDUtils.fillRect(x + 2, y + 13, 13, 2, 0, 0, 0, 255);
                HUDUtils.fillRect(x + 2, y + 13, barWidth, 1, barColor >> 16 & 0xFF, barColor >> 8 & 0xFF, barColor & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableCull();
                RenderSystem.enableDepthTest();
            }
            if (showCount) {
                int count = 0;
                if (Minecraft.getInstance().player != null) {
                    if (stack.getMaxStackSize() > 1) {
                        count = HUDUtils.countInInventory((Player)Minecraft.getInstance().player, stack.getItem(), stack.getDamageValue());
                    } else if (stack.getItem().equals(Items.BOW) || stack.getItem().equals(Items.CROSSBOW)) {
                        count = HUDUtils.countInInventory((Player)Minecraft.getInstance().player, Items.ARROW);
                    }
                }
                if (count > 1) {
                    String countString = String.valueOf(count);
                    graphics.pose().pushPose();
                    graphics.pose().translate(0.0f, 0.0f, 300.0f);
                    graphics.drawString(font, countString, x + 19 - 2 - font.width(countString), y + 6 + 3, 0xFFFFFF);
                    graphics.pose().popPose();
                }
            }
        }
    }

    private static void fillRect(int x, int y, int width, int height, int r, int g, int b, int a) {
        BufferBuilder builder = RenderSystem.renderThreadTesselator().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex((float)x, (float)y, 0.0f).setColor(r, g, b, a);
        builder.addVertex((float)x, (float)(y + height), 0.0f).setColor(r, g, b, a);
        builder.addVertex((float)(x + width), (float)(y + height), 0.0f).setColor(r, g, b, a);
        builder.addVertex((float)(x + width), (float)y, 0.0f).setColor(r, g, b, a);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    private static int countInInventory(Player player, Item item) {
        return HUDUtils.countInInventory(player, item, -1);
    }

    private static int countInInventory(Player player, Item item, int datage) {
        int count = 0;
        for (ItemStack stack : player.getInventory().items) {
            if (stack.isEmpty() || !item.equals(stack.getItem()) || datage != -1 && stack.getDamageValue() != datage) continue;
            count += stack.getCount();
        }
        return count;
    }

    public static <T extends Component> Component stripCtrl(T text) {
        return Component.literal((String)text.getString().replaceAll("(?i)\u00a7[0-9a-fklmnor]", ""));
    }
}

