/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.armorstatushud.render;

import bspkrs.armorstatushud.ArmorStatusHUD;
import bspkrs.armorstatushud.config.Config;
import bspkrs.armorstatushud.render.HUDElement;
import bspkrs.armorstatushud.utils.ColorThreshold;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.world.item.ItemStack;

class RenderHandler {
    private static final List<HUDElement> elements = new ArrayList<HUDElement>();

    RenderHandler() {
    }

    static List<ColorThreshold> getColorList() {
        ArrayList<ColorThreshold> colorList = new ArrayList<ColorThreshold>();
        try {
            for (String s : ((String)Config.Client.DAMAGE_COLOR_LIST.get()).split(";")) {
                String[] ct = s.split(",");
                colorList.add(new ColorThreshold(Integer.parseInt(ct[0].trim()), ct[1].trim()));
            }
        }
        catch (Throwable e) {
            ArmorStatusHUD.LOGGER.warn("Error encountered parsing damageColorList: {}", Config.Client.DAMAGE_COLOR_LIST.get());
            ArmorStatusHUD.LOGGER.warn("Reverting to defaultColorList: {}", (Object)"100,f; 80,7; 60,e; 40,6; 25,c; 10,4");
            for (String s : "100,f; 80,7; 60,e; 40,6; 25,c; 10,4".split(";")) {
                String[] ct = s.split(",");
                colorList.add(new ColorThreshold(Integer.parseInt(ct[0].trim()), ct[1].trim()));
            }
        }
        Collections.sort(colorList);
        return colorList;
    }

    static void onTickInGame(GuiGraphics graphics, Minecraft minecraft) {
        boolean showInChat;
        boolean bl = showInChat = minecraft.screen instanceof ChatScreen && (Boolean)Config.Client.SHOW_IN_CHAT.get() != false;
        if (((Boolean)Config.Client.ENABLED.get()).booleanValue() && (minecraft.screen == null || showInChat) && !minecraft.options.hideGui) {
            RenderHandler.displayArmorStatus(graphics, minecraft);
        }
    }

    private static int getX(int width) {
        String alignMode = ((Config.AlignMode)((Object)Config.Client.ALIGN_MODE.get())).name().toLowerCase();
        if (alignMode.contains("center")) {
            return Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 - width / 2 + ((Boolean)Config.Client.APPLY_X_OFFSET_TO_CENTER.get() != false ? (Integer)Config.Client.X_OFFSET.get() : 0);
        }
        if (alignMode.contains("right")) {
            return Minecraft.getInstance().getWindow().getGuiScaledWidth() - width - (Integer)Config.Client.X_OFFSET.get();
        }
        return (Integer)Config.Client.X_OFFSET.get();
    }

    private static int getY(int rowCount, int height) {
        String alignMode = ((Config.AlignMode)((Object)Config.Client.ALIGN_MODE.get())).name().toLowerCase();
        if (alignMode.contains("middle")) {
            return Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2 - rowCount * height / 2 + ((Boolean)Config.Client.APPLY_Y_OFFSET_TO_MIDDLE.get() != false ? (Integer)Config.Client.Y_OFFSET.get() : 0);
        }
        if (alignMode.equals("bottomleft") || alignMode.equals("bottomright")) {
            return Minecraft.getInstance().getWindow().getGuiScaledHeight() - rowCount * height - (Integer)Config.Client.Y_OFFSET.get();
        }
        if (alignMode.equals("bottomcenter")) {
            return Minecraft.getInstance().getWindow().getGuiScaledHeight() - rowCount * height - (Integer)Config.Client.Y_OFFSET_BOTTOM_CENTER.get();
        }
        return (Integer)Config.Client.Y_OFFSET.get();
    }

    private static void getHUDElements(Minecraft minecraft) {
        elements.clear();
        if (minecraft.player != null) {
            for (int i = 3; i >= -2; --i) {
                ItemStack stack = null;
                if (i == -1 && ((Boolean)Config.Client.SHOW_EQUIPPED_ITEM.get()).booleanValue()) {
                    stack = minecraft.player.getMainHandItem();
                } else if (i == -2 && ((Boolean)Config.Client.SHOW_OFFHAND_ITEM.get()).booleanValue()) {
                    stack = minecraft.player.getOffhandItem();
                } else if (i != -1 && i != -2) {
                    stack = (ItemStack)minecraft.player.getInventory().armor.get(i);
                }
                if (stack == null || stack.isEmpty()) continue;
                elements.add(new HUDElement(stack, 16, 16, 2, i > -1));
            }
        }
    }

    private static int getElementsWidth() {
        return elements.stream().map(HUDElement::width).reduce(0, Integer::sum);
    }

    private static void displayArmorStatus(GuiGraphics graphics, Minecraft minecraft) {
        block2: {
            int yOffset;
            block3: {
                RenderHandler.getHUDElements(minecraft);
                if (elements.isEmpty()) break block2;
                int n = yOffset = (Boolean)Config.Client.SHOW_ITEM_NAME.get() != false ? 18 : 16;
                if (Config.Client.LIST_MODE.get() != Config.ListMode.VERTICAL) break block3;
                int yBase = RenderHandler.getY(elements.size(), yOffset);
                for (HUDElement element : elements) {
                    element.renderToHud(graphics, ((Config.AlignMode)((Object)Config.Client.ALIGN_MODE.get())).name().toLowerCase().contains("right") ? RenderHandler.getX(0) : RenderHandler.getX(element.width()), yBase);
                    yBase += yOffset;
                }
                break block2;
            }
            if (Config.Client.LIST_MODE.get() != Config.ListMode.HORIZONTAL) break block2;
            int xBase = RenderHandler.getX(RenderHandler.getElementsWidth());
            int yBase = RenderHandler.getY(1, yOffset);
            int prevX = 0;
            for (HUDElement element : elements) {
                element.renderToHud(graphics, xBase + prevX + (((Config.AlignMode)((Object)Config.Client.ALIGN_MODE.get())).name().toLowerCase().contains("right") ? element.width() : 0), yBase);
                prevX += element.width();
            }
        }
    }
}

