/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.armorstatushud.render;

import bspkrs.armorstatushud.config.Config;
import bspkrs.armorstatushud.render.RenderHandler;
import bspkrs.armorstatushud.utils.ColorThreshold;
import bspkrs.armorstatushud.utils.HUDUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

class HUDElement {
    private final Minecraft minecraft = Minecraft.getInstance();
    private final ItemStack itemStack;
    private final int iconWidth;
    private final int iconHeight;
    private final int padWidth;
    private final boolean isArmor;
    private int elementWidth;
    private int elementHeight;
    private Component itemName = Component.literal((String)"");
    private int itemNameWidth;
    private String itemDamage = "";
    private int itemDamageWidth;

    HUDElement(ItemStack itemStack, int iconWidth, int iconHeight, int padWidth, boolean isArmor) {
        this.itemStack = itemStack;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.padWidth = padWidth;
        this.isArmor = isArmor;
        this.initSize();
    }

    int width() {
        return this.elementWidth;
    }

    private void initSize() {
        if (((Boolean)Config.Client.SHOW_ITEM_NAME.get()).booleanValue()) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            v0 = Math.max(9 * 2, this.iconHeight);
        } else {
            Objects.requireNonNull(this.minecraft.font);
            v0 = this.elementHeight = Math.max(9, this.iconHeight);
        }
        if (this.itemStack != null) {
            if ((this.isArmor && ((Boolean)Config.Client.SHOW_ARMOR_DAMAGE.get()).booleanValue() || !this.isArmor && ((Boolean)Config.Client.SHOW_ITEM_DAMAGE.get()).booleanValue()) && this.itemStack.isDamageableItem()) {
                int maxDamage = this.itemStack.getMaxDamage();
                int damage = maxDamage - this.itemStack.getDamageValue();
                if (Config.Client.DAMAGE_DISPLAY_TYPE.get() == Config.DamageDisplayType.VALUE) {
                    this.itemDamage = "\u00a7" + ColorThreshold.getColorCode(RenderHandler.getColorList(), Config.Client.DAMAGE_THRESHOLD_TYPE.get() == Config.DamageTresholdType.PERCENT ? damage * 100 / maxDamage : damage) + damage + (String)((Boolean)Config.Client.SHOW_MAX_DAMAGE.get() != false ? "/" + maxDamage : "");
                } else if (Config.Client.DAMAGE_DISPLAY_TYPE.get() == Config.DamageDisplayType.PERCENT) {
                    this.itemDamage = "\u00a7" + ColorThreshold.getColorCode(RenderHandler.getColorList(), Config.Client.DAMAGE_THRESHOLD_TYPE.get() == Config.DamageTresholdType.PERCENT ? damage * 100 / maxDamage : damage) + damage * 100 / maxDamage + "%";
                }
            }
            this.itemDamageWidth = this.minecraft.font.width((FormattedText)HUDUtils.stripCtrl(Component.literal((String)this.itemDamage)));
            this.elementWidth = this.padWidth + this.iconWidth + this.padWidth + this.itemDamageWidth;
            if (((Boolean)Config.Client.SHOW_ITEM_NAME.get()).booleanValue()) {
                this.itemName = this.itemStack.getDisplayName();
                this.elementWidth = this.padWidth + this.iconWidth + this.padWidth + Math.max(this.minecraft.font.width((FormattedText)HUDUtils.stripCtrl(this.itemName)), this.itemDamageWidth);
            }
            this.itemNameWidth = this.minecraft.font.width((FormattedText)HUDUtils.stripCtrl(this.itemName));
        }
    }

    void renderToHud(GuiGraphics graphics, int x, int y) {
        if (((Config.AlignMode)((Object)Config.Client.ALIGN_MODE.get())).name().toLowerCase().contains("right")) {
            graphics.renderItem(this.itemStack, x - (this.iconWidth + this.padWidth), y, 0, 100);
            HUDUtils.renderItemOverlayIntoGUI(graphics, this.minecraft.font, this.itemStack, x - (this.iconWidth + this.padWidth), y, (Boolean)Config.Client.SHOW_DAMAGE_OVERLAY.get(), (Boolean)Config.Client.SHOW_ITEM_COUNT.get());
            if (((Boolean)Config.Client.SHOW_ITEM_NAME.get()).booleanValue()) {
                graphics.drawString(this.minecraft.font, this.itemName, x - (this.iconWidth + this.padWidth * 2) - this.itemNameWidth, y, 0xFFFFFF, true);
                graphics.drawString(this.minecraft.font, this.itemDamage, (float)(x - (this.iconWidth + this.padWidth * 2) - this.itemDamageWidth), (float)y + (float)this.elementHeight / 2.0f, 0xFFFFFF, true);
            } else {
                graphics.drawString(this.minecraft.font, this.itemDamage, (float)(x - (this.iconWidth + this.padWidth * 2) - this.itemDamageWidth), (float)y + (float)this.elementHeight / 4.0f, 0xFFFFFF, true);
            }
        } else {
            graphics.renderItem(this.itemStack, x, y, 0, 100);
            HUDUtils.renderItemOverlayIntoGUI(graphics, this.minecraft.font, this.itemStack, x, y, (Boolean)Config.Client.SHOW_DAMAGE_OVERLAY.get(), (Boolean)Config.Client.SHOW_ITEM_COUNT.get());
            if (((Boolean)Config.Client.SHOW_ITEM_NAME.get()).booleanValue()) {
                graphics.drawString(this.minecraft.font, this.itemName, x + this.iconWidth + this.padWidth, y, 0xFFFFFF, true);
                graphics.drawString(this.minecraft.font, this.itemDamage, (float)(x + this.iconWidth + this.padWidth), (float)y + (float)this.elementHeight / 2.0f, 0xFFFFFF, true);
            } else {
                graphics.drawString(this.minecraft.font, this.itemDamage, (float)(x + this.iconWidth + this.padWidth), (float)y + (float)this.elementHeight / 4.0f, 0xFFFFFF, true);
            }
        }
        graphics.flush();
    }
}

