/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.util;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class StringUtils {
    public static String normalizeText(String text) {
        text = text.toLowerCase();
        text = Normalizer.normalize(text, Normalizer.Form.NFD);
        text = text.replaceAll("\\p{M}", "");
        return text;
    }

    public static int levenshteinDistance(String a, String b) {
        int[][] dp = new int[a.length() + 1][b.length() + 1];
        for (int i = 0; i <= a.length(); ++i) {
            for (int j = 0; j <= b.length(); ++j) {
                dp[i][j] = i == 0 ? j : (j == 0 ? i : Math.min(Math.min(dp[i - 1][j] + 1, dp[i][j - 1] + 1), dp[i - 1][j - 1] + (a.charAt(i - 1) == b.charAt(j - 1) ? 0 : 1)));
            }
        }
        return dp[a.length()][b.length()];
    }

    public static <T> List<T> searchElements(Iterable<T> elements, String query, Function<T, String> extractSearchableText) {
        String normalizedQuery = StringUtils.normalizeText(query);
        ArrayList<T> exactMatches = new ArrayList<T>();
        ArrayList<T> approxMatches = new ArrayList<T>();
        for (T element : elements) {
            String normalizedName = StringUtils.normalizeText(extractSearchableText.apply(element));
            if (StringUtils.boyerMooreSearch(normalizedName, normalizedQuery) != -1) {
                exactMatches.add(element);
                continue;
            }
            int nameDistance = StringUtils.levenshteinDistance(normalizedName, normalizedQuery);
            if (nameDistance >= normalizedQuery.length() / 2) continue;
            approxMatches.add(element);
        }
        ArrayList<T> results = new ArrayList<T>(exactMatches);
        results.addAll(approxMatches);
        return results;
    }

    public static int boyerMooreSearch(String text, String pattern) {
        int goodSuffixShift;
        int badCharShift;
        int j;
        pattern = StringUtils.normalizeText(pattern);
        int patternLength = pattern.length();
        int textLength = text.length();
        if (patternLength == 0) {
            return 0;
        }
        HashMap<Character, Integer> badCharTable = new HashMap<Character, Integer>();
        StringUtils.buildBadCharTable(badCharTable, pattern);
        int[] suffixArray = new int[patternLength + 1];
        int[] shiftTable = new int[patternLength + 1];
        Arrays.fill(shiftTable, 0);
        StringUtils.computeFullShiftTable(shiftTable, suffixArray, pattern);
        StringUtils.computeGoodSuffixShiftTable(shiftTable, suffixArray, pattern);
        for (int shift = 0; shift <= textLength - patternLength; shift += Math.max(j - badCharShift, goodSuffixShift)) {
            for (j = patternLength - 1; j >= 0 && pattern.charAt(j) == text.charAt(shift + j); --j) {
            }
            if (j < 0) {
                return shift;
            }
            char mismatchedChar = text.charAt(shift + j);
            badCharShift = badCharTable.getOrDefault(Character.valueOf(mismatchedChar), -1);
            goodSuffixShift = j + 1 < patternLength ? shiftTable[j + 1] : 1;
        }
        return -1;
    }

    public static void computeFullShiftTable(int[] shiftTable, int[] suffixArray, String pattern) {
        int j;
        int patternLength;
        int i = patternLength = pattern.length();
        suffixArray[i] = j = patternLength + 1;
        while (i > 0) {
            while (j <= patternLength && pattern.charAt(i - 1) != pattern.charAt(j - 1)) {
                if (shiftTable[j] == 0) {
                    shiftTable[j] = j - i;
                }
                j = suffixArray[j];
            }
            suffixArray[--i] = --j;
        }
    }

    public static void computeGoodSuffixShiftTable(int[] shiftTable, int[] suffixArray, String pattern) {
        int patternLength = pattern.length();
        int j = suffixArray[0];
        for (int i = 0; i < patternLength; ++i) {
            if (shiftTable[i] == 0) {
                shiftTable[i] = j;
            }
            if (i != j) continue;
            j = suffixArray[j];
        }
    }

    public static void buildBadCharTable(Map<Character, Integer> badCharTable, String pattern) {
        int patternLength = pattern.length();
        for (int i = 0; i < patternLength - 1; ++i) {
            badCharTable.put(Character.valueOf(pattern.charAt(i)), i);
        }
    }
}

