/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.scripting;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import tschipp.carryon.Constants;
import tschipp.carryon.common.scripting.CarryOnScript;

public class ScriptManager {
    public static final List<CarryOnScript> SCRIPTS = new ArrayList<CarryOnScript>();

    public static Optional<CarryOnScript> inspectBlock(BlockState state, Level level, BlockPos pos, @Nullable CompoundTag tag) {
        if (!Constants.COMMON_CONFIG.settings.useScripts) {
            return Optional.empty();
        }
        Block block = state.getBlock();
        float hardness = state.getDestroySpeed((BlockGetter)level, pos);
        float resistance = block.getExplosionResistance();
        for (CarryOnScript script : SCRIPTS) {
            if (!script.isBlock() || !ScriptManager.matchesAll(script, block, hardness, resistance, tag)) continue;
            return Optional.of(script);
        }
        return Optional.empty();
    }

    public static Optional<CarryOnScript> inspectEntity(Entity entity) {
        if (!Constants.COMMON_CONFIG.settings.useScripts) {
            return Optional.empty();
        }
        float height = entity.getBbHeight();
        float width = entity.getBbWidth();
        float health = entity instanceof LivingEntity ? ((LivingEntity)entity).getHealth() : 0.0f;
        CompoundTag tag = new CompoundTag();
        entity.save(tag);
        for (CarryOnScript script : SCRIPTS) {
            if (!script.isEntity() || !ScriptManager.matchesAll(script, entity, height, width, health, tag)) continue;
            return Optional.of(script);
        }
        return Optional.empty();
    }

    private static boolean matchesAll(CarryOnScript script, Entity entity, float height, float width, float health, CompoundTag tag) {
        CarryOnScript.ScriptObject.ScriptObjectEntity scEntity = script.scriptObject().entity();
        boolean matchname = true;
        if (scEntity.typeNameEntity().isPresent()) {
            matchname = entity.getType().equals(BuiltInRegistries.ENTITY_TYPE.get(scEntity.typeNameEntity().get()));
        }
        boolean matchheight = scEntity.typeHeight().matches(Float.valueOf(height));
        boolean matchwidth = scEntity.typeWidth().matches(Float.valueOf(width));
        boolean matchhealth = scEntity.typeHealth().matches(Float.valueOf(health));
        boolean matchnbt = scEntity.typeEntityTag().matches(tag);
        return matchname && matchheight && matchwidth && matchhealth && matchnbt;
    }

    private static boolean matchesAll(CarryOnScript script, Block block, float hardness, float resistance, CompoundTag nbt) {
        CarryOnScript.ScriptObject.ScriptObjectBlock scBlock = script.scriptObject().block();
        boolean matchblock = true;
        if (scBlock.typeNameBlock().isPresent()) {
            matchblock = block == BuiltInRegistries.BLOCK.get(scBlock.typeNameBlock().get());
        }
        boolean matchnbt = scBlock.typeBlockTag().matches(nbt);
        boolean matchhardness = scBlock.typeHardness().matches(Float.valueOf(hardness));
        boolean matchresistance = scBlock.typeResistance().matches(Float.valueOf(resistance));
        return matchnbt && matchblock && matchhardness && matchresistance;
    }
}

