/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut.network;

import com.corosus.watut.WatutMod;
import com.corosus.watut.network.PacketBase;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record PacketNBTFromClient(CompoundTag nbt) implements PacketBase
{
    public static final CustomPacketPayload.Type<PacketNBTFromClient> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"watut", (String)"nbt_server"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketNBTFromClient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, PacketNBTFromClient::nbt, PacketNBTFromClient::new);

    public PacketNBTFromClient(RegistryFriendlyByteBuf buf) {
        this(buf.readNbt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.nbt);
    }

    public void handle(Player player) {
        try {
            if (player != null) {
                WatutMod.getPlayerStatusManagerServer().receiveAny(player, this.nbt);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

