/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.api.data.v2.core;

import com.google.common.base.Function;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.data.v2.core.RegistriesDataProvider;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.api.data.v2.core.NeoForgeDataProviderContext;
import fuzs.puzzleslib.neoforge.impl.data.FileHelperDataProvider;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataProvider;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public final class DataProviderHelper {
    private DataProviderHelper() {
    }

    public static void registerDataProviders(String modId, NeoForgeDataProviderContext.Factory ... factories) {
        DataProviderHelper.registerDataProviders(modId, new RegistrySetBuilder(), factories);
    }

    public static void registerDataProviders(String modId, RegistrySetBuilder registrySetBuilder, NeoForgeDataProviderContext.Factory ... factories) {
        DataProviderHelper.registerDataProviders(modId, registrySetBuilder, factories, factory -> (evt, registries) -> (DataProvider)factory.apply(NeoForgeDataProviderContext.fromEvent(modId, evt, registries)));
    }

    public static void registerDataProviders(String modId, NeoForgeDataProviderContext.LegacyFactory ... factories) {
        DataProviderHelper.registerDataProviders(modId, new RegistrySetBuilder(), factories);
    }

    public static void registerDataProviders(String modId, RegistrySetBuilder registrySetBuilder, NeoForgeDataProviderContext.LegacyFactory ... factories) {
        DataProviderHelper.registerDataProviders(modId, registrySetBuilder, factories, factory -> (evt, registries) -> (DataProvider)factory.apply(evt, modId));
    }

    static <T> void registerDataProviders(String modId, RegistrySetBuilder registrySetBuilder, T[] factories, Function<T, Factory> factoryConverter) {
        if (!ModLoaderEnvironment.INSTANCE.isDataGeneration()) {
            return;
        }
        NeoForgeModContainerHelper.getOptionalModEventBus(modId).ifPresent(eventBus -> eventBus.addListener(evt -> {
            CompletableFuture<HolderLookup.Provider> registries = evt.getLookupProvider();
            if (!registrySetBuilder.getEntryKeys().isEmpty()) {
                registries = ((DatapackBuiltinEntriesProvider)evt.getGenerator().addProvider(true, (DataProvider)new DatapackBuiltinEntriesProvider(evt.getGenerator().getPackOutput(), (CompletableFuture)registries, registrySetBuilder, Collections.singleton(modId)))).getRegistryProvider();
            }
            for (Object factory : factories) {
                DataProvider dataProvider = (DataProvider)((Factory)factoryConverter.apply(factory)).apply(evt, registries);
                if (dataProvider instanceof RegistriesDataProvider) {
                    RegistriesDataProvider registriesDataProvider = (RegistriesDataProvider)dataProvider;
                    registries = registriesDataProvider.getRegistries();
                }
                if (dataProvider instanceof FileHelperDataProvider) {
                    FileHelperDataProvider fileHelperDataProvider = (FileHelperDataProvider)dataProvider;
                    fileHelperDataProvider.puzzleslib$setExistingFileHelper(evt.getExistingFileHelper());
                }
                evt.getGenerator().addProvider(true, dataProvider);
            }
        }));
    }

    @FunctionalInterface
    static interface Factory
    extends BiFunction<GatherDataEvent, CompletableFuture<HolderLookup.Provider>, DataProvider> {
    }
}

