/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.attachment.builder;

import fuzs.puzzleslib.api.attachment.v4.DataAttachmentRegistry;
import fuzs.puzzleslib.api.event.v1.entity.player.AfterChangeDimensionCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerCopyEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerNetworkEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerTrackingEvents;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.impl.attachment.AttachmentTypeAdapter;
import fuzs.puzzleslib.impl.attachment.ClientboundEntityDataAttachmentMessage;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public interface EntityDataAttachmentBuilder<V>
extends DataAttachmentRegistry.EntityBuilder<V> {
    @Nullable
    default public BiConsumer<Entity, V> getSynchronizer(ResourceLocation resourceLocation, AttachmentTypeAdapter<Entity, V> attachmentType, @Nullable StreamCodec<? super RegistryFriendlyByteBuf, V> streamCodec, @Nullable Function<Entity, PlayerSet> synchronizationTargets) {
        if (streamCodec == null) {
            return null;
        }
        CustomPacketPayload.Type type = new CustomPacketPayload.Type(resourceLocation);
        this.registerPayloadHandlers(resourceLocation, attachmentType, type, streamCodec);
        this.registerEventHandlers(attachmentType, type, synchronizationTargets);
        return this.getDefaultSynchronizer(type, synchronizationTargets);
    }

    public void registerPayloadHandlers(ResourceLocation var1, AttachmentTypeAdapter<Entity, V> var2, CustomPacketPayload.Type<ClientboundEntityDataAttachmentMessage<V>> var3, @Nullable StreamCodec<? super RegistryFriendlyByteBuf, V> var4);

    private void registerEventHandlers(AttachmentTypeAdapter<Entity, V> attachmentType, CustomPacketPayload.Type<ClientboundEntityDataAttachmentMessage<V>> type, @Nullable Function<Entity, PlayerSet> synchronizationTargets) {
        PlayerNetworkEvents.LOGGED_IN.register(serverPlayer -> this.broadcast(type, serverPlayer, attachmentType));
        AfterChangeDimensionCallback.EVENT.register((serverPlayer, from, to) -> this.broadcast(type, serverPlayer, attachmentType));
        PlayerCopyEvents.RESPAWN.register((serverPlayer, originalStillAlive) -> this.broadcast(type, serverPlayer, attachmentType));
        if (synchronizationTargets != null) {
            PlayerTrackingEvents.START.register((trackedEntity, serverPlayer) -> this.broadcast(type, trackedEntity, PlayerSet.ofPlayer(serverPlayer), (V)attachmentType));
        }
    }

    private BiConsumer<Entity, V> getDefaultSynchronizer(CustomPacketPayload.Type<ClientboundEntityDataAttachmentMessage<V>> type, @Nullable Function<Entity, PlayerSet> synchronizationTargets) {
        return (entity, value) -> {
            PlayerSet playerSet = synchronizationTargets != null ? (PlayerSet)synchronizationTargets.apply((Entity)entity) : PlayerSet.ofEntity(entity);
            this.broadcast(type, (Entity)entity, playerSet, (V)value);
        };
    }

    private void broadcast(CustomPacketPayload.Type<ClientboundEntityDataAttachmentMessage<V>> type, ServerPlayer serverPlayer, AttachmentTypeAdapter<Entity, V> attachmentType) {
        this.broadcast(type, (Entity)serverPlayer, PlayerSet.ofPlayer(serverPlayer), (V)attachmentType);
    }

    private void broadcast(CustomPacketPayload.Type<ClientboundEntityDataAttachmentMessage<V>> type, Entity entity, PlayerSet playerSet, AttachmentTypeAdapter<Entity, V> attachmentType) {
        if (attachmentType.hasData(entity)) {
            this.broadcast(type, entity, playerSet, attachmentType.getData(entity));
        }
    }

    private void broadcast(CustomPacketPayload.Type<ClientboundEntityDataAttachmentMessage<V>> type, Entity entity, PlayerSet playerSet, @Nullable V value) {
        ClientboundEntityDataAttachmentMessage<V> message = new ClientboundEntityDataAttachmentMessage<V>(type, entity.getId(), Optional.ofNullable(value));
        playerSet.broadcast(type, (Packet<?>)new ClientboundCustomPayloadPacket(message));
    }
}

