/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.entity;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import teamdraco.unnamedanimalmod.entity.Capybara;

public class CapybaraModel
extends AgeableListModel<Capybara> {
    private final ModelPart body;
    private final ModelPart rightBackLeg;
    private final ModelPart leftBackLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart head;
    private final ModelPart chestLeft;
    private final ModelPart chestRight;
    private final ModelPart earRight;
    private final ModelPart earLeft;
    private final ModelPart hat;
    private final ModelPart hatBrim;

    public CapybaraModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.chestRight = this.body.getChild("chestRight");
        this.chestLeft = this.body.getChild("chestLeft");
        this.earRight = this.head.getChild("earRight");
        this.earLeft = this.head.getChild("earLeft");
        this.hat = this.head.getChild("hat");
        this.hatBrim = this.hat.getChild("hatBrim");
        this.rightBackLeg = root.getChild("rightBackLeg");
        this.leftBackLeg = root.getChild("leftBackLeg");
        this.rightFrontLeg = root.getChild("rightFrontLeg");
        this.leftFrontLeg = root.getChild("leftFrontLeg");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("rightBackLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 11.0f, 5.0f), PartPose.offset((float)-3.5f, (float)13.3f, (float)10.0f));
        modelPartData.addOrReplaceChild("leftBackLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, 0.0f, -2.5f, 5.0f, 11.0f, 5.0f), PartPose.offset((float)3.5f, (float)13.3f, (float)10.0f));
        modelPartData.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(50, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f), PartPose.offset((float)-4.0f, (float)13.3f, (float)-8.0f));
        modelPartData.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(50, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 11.0f, 4.0f), PartPose.offset((float)4.0f, (float)13.3f, (float)-8.0f));
        PartDefinition modelPartData1 = modelPartData.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -7.0f, -11.0f, 14.0f, 14.0f, 22.0f), PartPose.offset((float)0.0f, (float)11.0f, (float)0.0f));
        modelPartData1.addOrReplaceChild("chestRight", CubeListBuilder.create().texOffs(40, 58).addBox(-2.0f, -4.0f, -4.0f, 2.0f, 8.0f, 8.0f), PartPose.offset((float)-7.0f, (float)-3.0f, (float)4.0f));
        modelPartData1.addOrReplaceChild("chestLeft", CubeListBuilder.create().texOffs(60, 58).addBox(0.0f, -4.0f, -4.0f, 2.0f, 8.0f, 8.0f, true), PartPose.offset((float)7.0f, (float)-3.0f, (float)4.0f));
        PartDefinition modelPartData2 = modelPartData.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 36).addBox(-4.0f, -5.5f, -11.0f, 8.0f, 10.0f, 14.0f), PartPose.offset((float)0.0f, (float)4.5f, (float)-10.0f));
        modelPartData2.addOrReplaceChild("earRight", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -2.0f, -1.0f, 1.0f, 3.0f, 3.0f), PartPose.offset((float)-3.5f, (float)-5.0f, (float)1.5f));
        modelPartData2.addOrReplaceChild("earLeft", CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, -2.0f, -1.0f, 1.0f, 3.0f, 3.0f, true), PartPose.offset((float)3.5f, (float)-5.0f, (float)1.5f));
        PartDefinition modelPartData3 = modelPartData2.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(30, 36).addBox(-3.5f, -4.0f, -1.5f, 7.0f, 4.0f, 7.0f), PartPose.offset((float)0.0f, (float)-5.1f, (float)-1.5f));
        modelPartData3.addOrReplaceChild("hatBrim", CubeListBuilder.create().texOffs(45, 17).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 0.0f, 5.0f), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.5f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)80, (int)74);
    }

    protected Iterable<ModelPart> headParts() {
        return Collections.EMPTY_LIST;
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.leftBackLeg, (Object)this.leftFrontLeg, (Object)this.rightBackLeg, (Object)this.rightFrontLeg, (Object)this.head);
    }

    public void setupAnim(Capybara entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.earRight.xRot = -0.3926991f;
        this.earRight.yRot = -0.3926991f;
        this.body.xRot = -0.08726646f;
        this.hat.xRot = -0.312763f;
        this.earLeft.xRot = -0.3926991f;
        this.earLeft.yRot = 0.3926991f;
        float speed = 1.0f;
        float degree = 1.0f;
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = headYaw * ((float)Math.PI / 180);
        this.body.yRot = 0.0f;
        this.body.zRot = Mth.cos((float)(limbAngle * speed * 0.4f)) * degree * 0.15f * limbDistance;
        if (entity.isInWater()) {
            this.body.yRot = Mth.cos((float)(animationProgress * speed * 0.4f)) * degree * 0.05f * 1.0f;
            this.body.zRot = 0.0f;
            this.leftBackLeg.xRot = Mth.cos((float)(1.0f + animationProgress * speed * 0.4f)) * degree * 1.2f * 0.2f + 0.45f;
            this.rightBackLeg.xRot = Mth.cos((float)(1.0f + animationProgress * speed * 0.4f)) * degree * -1.2f * 0.2f + 0.45f;
            this.rightFrontLeg.xRot = Mth.cos((float)(1.0f + animationProgress * speed * 0.4f)) * degree * 0.8f * 0.2f + 0.45f;
            this.leftFrontLeg.xRot = Mth.cos((float)(1.0f + animationProgress * speed * 0.4f)) * degree * -0.8f * 0.2f + 0.45f;
            this.head.xRot += Mth.cos((float)(animationProgress * speed * 0.4f)) * degree * 0.2f * 0.2f - 0.25f;
        } else if (entity.isInSittingPose()) {
            this.body.y = 17.0f;
            this.body.yRot = 0.0f;
            this.rightBackLeg.y = 21.3f;
            this.rightBackLeg.yRot = -0.34906584f;
            this.rightBackLeg.xRot = 1.5708f;
            this.leftBackLeg.y = 21.3f;
            this.leftBackLeg.yRot = 0.34906584f;
            this.leftBackLeg.xRot = 1.5708f;
            this.rightFrontLeg.y = 22.3f;
            this.rightFrontLeg.yRot = 0.34906584f;
            this.rightFrontLeg.xRot = -1.5708f;
            this.leftFrontLeg.y = 22.3f;
            this.leftFrontLeg.yRot = -0.34906584f;
            this.leftFrontLeg.xRot = -1.5708f;
            this.head.y = 10.5f;
        } else {
            this.body.y = 11.0f;
            this.body.yRot = 0.0f;
            this.rightBackLeg.y = 13.3f;
            this.rightBackLeg.yRot = 0.0f;
            this.leftBackLeg.y = 13.3f;
            this.leftBackLeg.yRot = 0.0f;
            this.rightFrontLeg.y = 13.3f;
            this.rightFrontLeg.yRot = 0.0f;
            this.leftFrontLeg.y = 13.3f;
            this.leftFrontLeg.yRot = 0.0f;
            this.head.y = 4.5f;
            this.leftBackLeg.xRot = Mth.cos((float)(1.0f + limbAngle * speed * 0.4f)) * degree * 0.8f * limbDistance;
            this.rightBackLeg.xRot = Mth.cos((float)(1.0f + limbAngle * speed * 0.4f)) * degree * -0.8f * limbDistance;
            this.rightFrontLeg.xRot = Mth.cos((float)(1.0f + limbAngle * speed * 0.4f)) * degree * 0.8f * limbDistance;
            this.leftFrontLeg.xRot = Mth.cos((float)(1.0f + limbAngle * speed * 0.4f)) * degree * -0.8f * limbDistance;
        }
    }
}

