/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.unnamedanimalmod.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import teamdraco.unnamedanimalmod.UAM;
import teamdraco.unnamedanimalmod.entity.Capybara;
import teamdraco.unnamedanimalmod.entity.CapybaraModel;

public class CapybaraChestLayer
extends RenderLayer<Capybara, CapybaraModel> {
    private static final ResourceLocation SINGLE_CHEST = UAM.reloc("textures/entity/single_chest.png");
    private static final ResourceLocation DOUBLE_CHEST = UAM.reloc("textures/entity/double_chest.png");

    public CapybaraChestLayer(RenderLayerParent<Capybara, CapybaraModel> context) {
        super(context);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, Capybara entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        int chestCount = entity.getChestCount();
        if (chestCount > 0) {
            CapybaraModel model = (CapybaraModel)this.getParentModel();
            model.prepareMobModel((Entity)entity, limbAngle, limbDistance, tickDelta);
            model.setupAnim(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
            model.renderToBuffer(matrices, vertexConsumers.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)(chestCount > 1 ? DOUBLE_CHEST : SINGLE_CHEST))), light, OverlayTexture.NO_OVERLAY);
        }
    }
}

