/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.fluids.FluidStack;

public class CustomProcessingRecipeParams
extends ProcessingRecipeBuilder.ProcessingRecipeParams {
    protected static final ResourceLocation UNKNOWN = ResourceLocation.withDefaultNamespace((String)"unknown");
    public static final MapCodec<CustomProcessingRecipeParams> CODEC = CustomProcessingRecipeParams.codec(CustomProcessingRecipeParams::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, CustomProcessingRecipeParams> STREAM_CODEC = CustomProcessingRecipeParams.streamCodec(CustomProcessingRecipeParams::new);

    public CustomProcessingRecipeParams(ResourceLocation id) {
        super(id);
    }

    protected static <P extends CustomProcessingRecipeParams> MapCodec<P> codec(Function<ResourceLocation, P> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)FluidIngredient.CODEC, (Codec)Ingredient.CODEC).listOf().fieldOf("ingredients").forGetter(CustomProcessingRecipeParams::ingredients), (App)Codec.either((Codec)FluidStack.CODEC, (Codec)ProcessingOutput.CODEC).listOf().fieldOf("results").forGetter(CustomProcessingRecipeParams::results), (App)Codec.INT.optionalFieldOf("processing_time", (Object)0).forGetter(CustomProcessingRecipeParams::processingDuration), (App)HeatCondition.CODEC.optionalFieldOf("heat_requirement", (Object)HeatCondition.NONE).forGetter(CustomProcessingRecipeParams::requiredHeat)).apply((Applicative)instance, (ingredients, results, processingDuration, requiredHeat) -> {
            CustomProcessingRecipeParams params = (CustomProcessingRecipeParams)((Object)((Object)((Object)factory.apply(UNKNOWN))));
            ingredients.forEach(either -> either.ifRight(arg_0 -> params.ingredients.add(arg_0)).ifLeft(arg_0 -> params.fluidIngredients.add(arg_0)));
            results.forEach(either -> either.ifRight(arg_0 -> params.results.add(arg_0)).ifLeft(arg_0 -> params.fluidResults.add(arg_0)));
            params.processingDuration = processingDuration;
            params.requiredHeat = requiredHeat;
            return params;
        }));
    }

    protected static <P extends CustomProcessingRecipeParams> StreamCodec<RegistryFriendlyByteBuf, P> streamCodec(Function<ResourceLocation, P> constructor) {
        return StreamCodec.of((buffer, params) -> params.encode((RegistryFriendlyByteBuf)buffer), buffer -> (CustomProcessingRecipeParams)((Object)((Object)Util.make((Object)((Object)((CustomProcessingRecipeParams)((Object)((Object)constructor.apply(UNKNOWN))))), params -> params.decode((RegistryFriendlyByteBuf)buffer)))));
    }

    protected final List<Either<FluidIngredient, Ingredient>> ingredients() {
        ArrayList<Either<FluidIngredient, Ingredient>> ingredients = new ArrayList<Either<FluidIngredient, Ingredient>>(this.ingredients.size() + this.fluidIngredients.size());
        this.ingredients.forEach(ingredient -> ingredients.add(Either.right((Object)ingredient)));
        this.fluidIngredients.forEach(ingredient -> ingredients.add(Either.left((Object)ingredient)));
        return ingredients;
    }

    protected final List<Either<FluidStack, ProcessingOutput>> results() {
        ArrayList<Either<FluidStack, ProcessingOutput>> results = new ArrayList<Either<FluidStack, ProcessingOutput>>(this.results.size() + this.fluidResults.size());
        this.results.forEach(result -> results.add(Either.right((Object)result)));
        this.fluidResults.forEach(result -> results.add(Either.left((Object)result)));
        return results;
    }

    protected final int processingDuration() {
        return this.processingDuration;
    }

    protected final HeatCondition requiredHeat() {
        return this.requiredHeat;
    }

    protected void encode(RegistryFriendlyByteBuf buffer) {
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).encode((Object)buffer, (Object)this.ingredients);
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)ProcessingOutput.STREAM_CODEC).encode((Object)buffer, (Object)this.results);
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidIngredient.STREAM_CODEC).encode((Object)buffer, (Object)this.fluidIngredients);
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidStack.STREAM_CODEC).encode((Object)buffer, (Object)this.fluidResults);
        ByteBufCodecs.VAR_INT.encode((Object)buffer, (Object)this.processingDuration);
        HeatCondition.STREAM_CODEC.encode((Object)buffer, (Object)this.requiredHeat);
    }

    protected void decode(RegistryFriendlyByteBuf buffer) {
        this.ingredients = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).decode((Object)buffer);
        this.results = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)ProcessingOutput.STREAM_CODEC).decode((Object)buffer);
        this.fluidIngredients = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidIngredient.STREAM_CODEC).decode((Object)buffer);
        this.fluidResults = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidStack.STREAM_CODEC).decode((Object)buffer);
        this.processingDuration = (Integer)ByteBufCodecs.VAR_INT.decode((Object)buffer);
        this.requiredHeat = (HeatCondition)HeatCondition.STREAM_CODEC.decode((Object)buffer);
    }
}

