/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.saw;

import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.saw.SawMovementBehaviour;
import com.simibubi.create.content.kinetics.saw.TreeCutter;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import io.github.cotrin8672.cem.content.block.saw.EnchantableSawActorVisual;
import io.github.cotrin8672.cem.content.block.saw.EnchantableSawRenderer;
import io.github.cotrin8672.cem.util.AbstractBlockBreakQueueExtensionKt;
import io.github.cotrin8672.cem.util.EnchantedItemFactory;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0014J$\u0010\r\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0006H\u0014J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J(\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/github/cotrin8672/cem/content/block/saw/EnchantableSawMovementBehaviour;", "Lcom/simibubi/create/content/kinetics/saw/SawMovementBehaviour;", "<init>", "()V", "enchantedTools", "", "Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;", "Lnet/minecraft/world/item/ItemStack;", "destroyBlock", "", "context", "breakingPos", "Lnet/minecraft/core/BlockPos;", "onBlockBroken", "pos", "brokenState", "Lnet/minecraft/world/level/block/state/BlockState;", "getBlockBreakingSpeed", "", "createVisual", "Lcom/simibubi/create/content/contraptions/render/ActorVisual;", "visualizationContext", "Ldev/engine_room/flywheel/api/visualization/VisualizationContext;", "simulationWorld", "Lcom/simibubi/create/foundation/virtualWorld/VirtualRenderWorld;", "movementContext", "renderInContraption", "renderWorld", "matrices", "Lcom/simibubi/create/content/contraptions/render/ContraptionMatrices;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "createenchantablemachinery"})
public final class EnchantableSawMovementBehaviour
extends SawMovementBehaviour {
    @NotNull
    private final Map<MovementContext, ItemStack> enchantedTools = new WeakHashMap();

    protected void destroyBlock(@Nullable MovementContext context, @NotNull BlockPos breakingPos) {
        Intrinsics.checkNotNullParameter((Object)breakingPos, (String)"breakingPos");
        if (context == null) {
            return;
        }
        if (this.enchantedTools.get(context) == null) {
            this.enchantedTools.put(context, EnchantedItemFactory.INSTANCE.getPickaxeItemStack(context.blockEntityData, context));
        }
        BlockHelper.destroyBlockAs((Level)context.world, (BlockPos)breakingPos, null, (ItemStack)this.enchantedTools.get(context), (float)1.0f, arg_0 -> EnchantableSawMovementBehaviour.destroyBlock$lambda$0(this, context, arg_0));
    }

    protected void onBlockBroken(@Nullable MovementContext context, @Nullable BlockPos pos, @NotNull BlockState brokenState) {
        Intrinsics.checkNotNullParameter((Object)brokenState, (String)"brokenState");
        if (context == null) {
            return;
        }
        if (brokenState.is(BlockTags.LEAVES)) {
            return;
        }
        if (this.enchantedTools.get(context) == null) {
            this.enchantedTools.put(context, EnchantedItemFactory.INSTANCE.getPickaxeItemStack(context.blockEntityData, context));
        }
        Optional optional = TreeCutter.findDynamicTree((Block)brokenState.getBlock(), (BlockPos)pos);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findDynamicTree(...)");
        Optional dynamicTree = optional;
        if (dynamicTree.isPresent()) {
            Object t = dynamicTree.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            AbstractBlockBreakQueue abstractBlockBreakQueue = (AbstractBlockBreakQueue)t;
            Level level = context.world;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"world");
            ItemStack itemStack = this.enchantedTools.get(context);
            Intrinsics.checkNotNull((Object)itemStack);
            AbstractBlockBreakQueueExtensionKt.destroyBlocks(abstractBlockBreakQueue, level, itemStack, (Function2<? super BlockPos, ? super ItemStack, Unit>)((Function2)(arg_0, arg_1) -> EnchantableSawMovementBehaviour.onBlockBroken$lambda$1(this, context, arg_0, arg_1)));
            return;
        }
        TreeCutter.Tree tree = TreeCutter.findTree((BlockGetter)((BlockGetter)context.world), (BlockPos)pos, (BlockState)brokenState);
        Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"findTree(...)");
        AbstractBlockBreakQueue abstractBlockBreakQueue = (AbstractBlockBreakQueue)tree;
        Level level = context.world;
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"world");
        ItemStack itemStack = this.enchantedTools.get(context);
        Intrinsics.checkNotNull((Object)itemStack);
        AbstractBlockBreakQueueExtensionKt.destroyBlocks(abstractBlockBreakQueue, level, itemStack, (Function2<? super BlockPos, ? super ItemStack, Unit>)((Function2)(arg_0, arg_1) -> EnchantableSawMovementBehaviour.onBlockBroken$lambda$2(this, context, arg_0, arg_1)));
    }

    protected float getBlockBreakingSpeed(@NotNull MovementContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.enchantedTools.get(context) == null) {
            this.enchantedTools.put(context, EnchantedItemFactory.INSTANCE.getPickaxeItemStack(context.blockEntityData, context));
        }
        HolderLookup holderLookup = context.world.holderLookup(Registries.ENCHANTMENT);
        Optional optional = holderLookup.get(Enchantments.EFFICIENCY);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"get(...)");
        Holder.Reference reference = (Holder.Reference)OptionalsKt.getOrNull((Optional)optional);
        if (reference == null) {
            return super.getBlockBreakingSpeed(context);
        }
        Holder.Reference holder = reference;
        ItemStack itemStack = this.enchantedTools.get(context);
        if (itemStack == null) {
            return super.getBlockBreakingSpeed(context);
        }
        int efficiencyLevel = itemStack.getEnchantmentLevel((Holder)holder);
        return super.getBlockBreakingSpeed(context) * (float)(efficiencyLevel + 1);
    }

    @NotNull
    public ActorVisual createVisual(@NotNull VisualizationContext visualizationContext, @NotNull VirtualRenderWorld simulationWorld, @NotNull MovementContext movementContext) {
        Intrinsics.checkNotNullParameter((Object)visualizationContext, (String)"visualizationContext");
        Intrinsics.checkNotNullParameter((Object)simulationWorld, (String)"simulationWorld");
        Intrinsics.checkNotNullParameter((Object)movementContext, (String)"movementContext");
        return new EnchantableSawActorVisual(visualizationContext, (BlockAndTintGetter)simulationWorld, movementContext);
    }

    public void renderInContraption(@NotNull MovementContext context, @NotNull VirtualRenderWorld renderWorld, @NotNull ContraptionMatrices matrices, @NotNull MultiBufferSource buffer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)renderWorld, (String)"renderWorld");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        EnchantableSawRenderer.Companion.renderInContraption(context, renderWorld, matrices, buffer);
    }

    private static final void destroyBlock$lambda$0(EnchantableSawMovementBehaviour this$0, MovementContext $context, ItemStack it) {
        this$0.dropItem($context, it);
    }

    private static final Unit onBlockBroken$lambda$1(EnchantableSawMovementBehaviour this$0, MovementContext $context, BlockPos stack, ItemStack dropPos) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)dropPos, (String)"dropPos");
        this$0.dropItemFromCutTree($context, stack, dropPos);
        return Unit.INSTANCE;
    }

    private static final Unit onBlockBroken$lambda$2(EnchantableSawMovementBehaviour this$0, MovementContext $context, BlockPos stack, ItemStack dropPos) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)dropPos, (String)"dropPos");
        this$0.dropItemFromCutTree($context, stack, dropPos);
        return Unit.INSTANCE;
    }
}

