/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.harvester;

import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterRenderer;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import io.github.cotrin8672.cem.config.CemConfig;
import io.github.cotrin8672.cem.content.block.harvester.EnchantableHarvesterRenderer;
import io.github.cotrin8672.cem.util.EnchantedItemFactory;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J(\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/github/cotrin8672/cem/content/block/harvester/EnchantableHarvesterMovementBehaviour;", "Lcom/simibubi/create/content/contraptions/actors/harvester/HarvesterMovementBehaviour;", "<init>", "()V", "enchantedTools", "", "Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;", "Lnet/minecraft/world/item/ItemStack;", "visitNewPosition", "", "context", "pos", "Lnet/minecraft/core/BlockPos;", "cutCrop", "Lnet/minecraft/world/level/block/state/BlockState;", "world", "Lnet/minecraft/world/level/Level;", "state", "createVisual", "Lcom/simibubi/create/content/contraptions/render/ActorVisual;", "visualizationContext", "Ldev/engine_room/flywheel/api/visualization/VisualizationContext;", "simulationWorld", "Lcom/simibubi/create/foundation/virtualWorld/VirtualRenderWorld;", "movementContext", "renderInContraption", "renderWorld", "matrices", "Lcom/simibubi/create/content/contraptions/render/ContraptionMatrices;", "buffers", "Lnet/minecraft/client/renderer/MultiBufferSource;", "createenchantablemachinery"})
public final class EnchantableHarvesterMovementBehaviour
extends HarvesterMovementBehaviour {
    @NotNull
    private final Map<MovementContext, ItemStack> enchantedTools = new WeakHashMap();

    public void visitNewPosition(@NotNull MovementContext context, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Level world = context.world;
        BlockState stateVisited = world.getBlockState(pos);
        boolean notCropButCuttable = false;
        if (world.isClientSide) {
            return;
        }
        if (!this.isValidCrop(world, pos, stateVisited)) {
            if (this.isValidOther(world, pos, stateVisited)) {
                notCropButCuttable = true;
            } else {
                return;
            }
        }
        if (this.enchantedTools.get(context) == null) {
            this.enchantedTools.put(context, EnchantedItemFactory.INSTANCE.getPickaxeItemStack(context.blockEntityData, context));
        }
        ItemStack item = this.enchantedTools.get(context);
        float effectChance = 1.0f;
        if (stateVisited.is(BlockTags.LEAVES)) {
            item = new ItemStack((ItemLike)Items.SHEARS);
            effectChance = 0.45f;
        }
        MutableBoolean seedSubtracted = new MutableBoolean(notCropButCuttable);
        BlockHelper.destroyBlockAs((Level)world, (BlockPos)pos, null, (ItemStack)item, (float)effectChance, arg_0 -> EnchantableHarvesterMovementBehaviour.visitNewPosition$lambda$0(seedSubtracted, stateVisited, this, context, arg_0));
        Intrinsics.checkNotNull((Object)world);
        Intrinsics.checkNotNull((Object)stateVisited);
        BlockState cutCrop = this.cutCrop(world, pos, stateVisited);
        world.setBlockAndUpdate(pos, cutCrop.canSurvive((LevelReader)world, pos) ? cutCrop : Blocks.AIR.defaultBlockState());
    }

    private final BlockState cutCrop(Level world, BlockPos pos, BlockState state) {
        if (!((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue()) {
            if (state.getFluidState().isEmpty()) {
                BlockState blockState = Blocks.AIR.defaultBlockState();
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
                return blockState;
            }
            BlockState blockState = state.getFluidState().createLegacyBlock();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"createLegacyBlock(...)");
            return blockState;
        }
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            BlockState blockState = ((CropBlock)block).getStateForAge(0);
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getStateForAge(...)");
            return blockState;
        }
        if (block == Blocks.SWEET_BERRY_BUSH) {
            Object object = state.setValue((Property)BlockStateProperties.AGE_3, (Comparable)Integer.valueOf(1));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
            return (BlockState)object;
        }
        if (block == Blocks.SUGAR_CANE || block instanceof GrowingPlantBlock) {
            if (state.getFluidState().isEmpty()) {
                BlockState blockState = Blocks.AIR.defaultBlockState();
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
                return blockState;
            }
            BlockState blockState = state.getFluidState().createLegacyBlock();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"createLegacyBlock(...)");
            return blockState;
        }
        if (state.getCollisionShape((BlockGetter)world, pos).isEmpty() || block instanceof CocoaBlock) {
            for (Property property : state.getProperties()) {
                if (!(property instanceof IntegerProperty) || !Intrinsics.areEqual((Object)((IntegerProperty)property).getName(), (Object)BlockStateProperties.AGE_1.getName())) continue;
                Object object = state.setValue(property, (Comparable)Integer.valueOf(0));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
                return (BlockState)object;
            }
        }
        if (state.getFluidState().isEmpty()) {
            BlockState blockState = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"defaultBlockState(...)");
            return blockState;
        }
        BlockState blockState = state.getFluidState().createLegacyBlock();
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"createLegacyBlock(...)");
        return blockState;
    }

    @Nullable
    public ActorVisual createVisual(@NotNull VisualizationContext visualizationContext, @NotNull VirtualRenderWorld simulationWorld, @NotNull MovementContext movementContext) {
        Intrinsics.checkNotNullParameter((Object)visualizationContext, (String)"visualizationContext");
        Intrinsics.checkNotNullParameter((Object)simulationWorld, (String)"simulationWorld");
        Intrinsics.checkNotNullParameter((Object)movementContext, (String)"movementContext");
        return null;
    }

    public void renderInContraption(@NotNull MovementContext context, @NotNull VirtualRenderWorld renderWorld, @NotNull ContraptionMatrices matrices, @NotNull MultiBufferSource buffers) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)renderWorld, (String)"renderWorld");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)buffers, (String)"buffers");
        HarvesterRenderer.renderInContraption((MovementContext)context, (VirtualRenderWorld)renderWorld, (ContraptionMatrices)matrices, (MultiBufferSource)buffers);
        if (((Boolean)CemConfig.Companion.getCONFIG().getRenderGlint().get()).booleanValue()) {
            EnchantableHarvesterRenderer.Companion.renderInContraption(context, renderWorld, matrices, buffers);
        }
    }

    private static final void visitNewPosition$lambda$0(MutableBoolean $seedSubtracted, BlockState $stateVisited, EnchantableHarvesterMovementBehaviour this$0, MovementContext $context, ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (((Boolean)AllConfigs.server().kinetics.harvesterReplants.get()).booleanValue() && !$seedSubtracted.getValue().booleanValue() && ItemHelper.sameItem((ItemStack)stack, (ItemStack)new ItemStack((ItemLike)$stateVisited.getBlock()))) {
            stack.shrink(1);
            $seedSubtracted.setTrue();
        }
        if (!stack.isEmpty()) {
            this$0.dropItem($context, stack);
        }
    }
}

