/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.drill;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.drill.DrillBlock;
import com.simibubi.create.content.kinetics.drill.DrillRenderer;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import io.github.cotrin8672.cem.client.CustomRenderType;
import io.github.cotrin8672.cem.config.CemConfig;
import io.github.cotrin8672.cem.content.block.drill.EnchantableDrillBlockEntity;
import io.github.cotrin8672.cem.util.BlockEntityExtensionKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.kotlinforforge.neoforge.forge.PoseStackUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014J8\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/cotrin8672/cem/content/block/drill/EnchantableDrillRenderer;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityRenderer;", "Lio/github/cotrin8672/cem/content/block/drill/EnchantableDrillBlockEntity;", "context", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "getRotatedModel", "Lnet/createmod/catnip/render/SuperByteBuffer;", "be", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "renderSafe", "", "partialTicks", "", "ms", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "light", "", "overlay", "Companion", "createenchantablemachinery"})
public final class EnchantableDrillRenderer
extends KineticBlockEntityRenderer<EnchantableDrillBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockEntityRendererProvider.Context context;
    private static final RandomSource RANDOM = RandomSource.create();

    public EnchantableDrillRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
    }

    @NotNull
    protected SuperByteBuffer getRotatedModel(@NotNull EnchantableDrillBlockEntity be, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        SuperByteBuffer superByteBuffer = CachedBuffers.partialFacing((PartialModel)AllPartialModels.DRILL_HEAD, (BlockState)state);
        Intrinsics.checkNotNullExpressionValue((Object)superByteBuffer, (String)"partialFacing(...)");
        return superByteBuffer;
    }

    protected void renderSafe(@NotNull EnchantableDrillBlockEntity be, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        SheetedDecalTextureGenerator consumer = new SheetedDecalTextureGenerator(buffer.getBuffer(CustomRenderType.Companion.getGLINT()), ms.last(), 0.007125f);
        BlockState state = this.getRenderedBlockState((KineticBlockEntity)be);
        PoseStackUtilKt.use((PoseStack)ms, () -> EnchantableDrillRenderer.renderSafe$lambda$0(this, be, ms, consumer, state, light));
    }

    private static final Unit renderSafe$lambda$0(EnchantableDrillRenderer this$0, EnchantableDrillBlockEntity $be, PoseStack $ms, SheetedDecalTextureGenerator $consumer, BlockState $state, int $light) {
        if (((Boolean)CemConfig.Companion.getCONFIG().getRenderGlint().get()).booleanValue()) {
            this$0.context.getBlockRenderDispatcher().renderBatched($be.getBlockState(), $be.getBlockPos(), (BlockAndTintGetter)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)$be), $ms, (VertexConsumer)$consumer, true, RANDOM);
            if (!VisualizationManager.supportsVisualization((LevelAccessor)((LevelAccessor)$be.getLevel()))) {
                KineticBlockEntity kineticBlockEntity = (KineticBlockEntity)$be;
                Intrinsics.checkNotNull((Object)$state);
                KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)kineticBlockEntity, (SuperByteBuffer)this$0.getRotatedModel($be, $state), (PoseStack)$ms, (VertexConsumer)((VertexConsumer)$consumer), (int)$light);
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/github/cotrin8672/cem/content/block/drill/EnchantableDrillRenderer$Companion;", "", "<init>", "()V", "RANDOM", "Lnet/minecraft/util/RandomSource;", "kotlin.jvm.PlatformType", "Lnet/minecraft/util/RandomSource;", "renderInContraption", "", "context", "Lcom/simibubi/create/content/contraptions/behaviour/MovementContext;", "renderWorld", "Lcom/simibubi/create/foundation/virtualWorld/VirtualRenderWorld;", "matrices", "Lcom/simibubi/create/content/contraptions/render/ContraptionMatrices;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "createenchantablemachinery"})
    public static final class Companion {
        private Companion() {
        }

        public final void renderInContraption(@NotNull MovementContext context, @NotNull VirtualRenderWorld renderWorld, @NotNull ContraptionMatrices matrices, @NotNull MultiBufferSource buffer) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)renderWorld, (String)"renderWorld");
            Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            DrillRenderer.renderInContraption((MovementContext)context, (VirtualRenderWorld)renderWorld, (ContraptionMatrices)matrices, (MultiBufferSource)buffer);
            BlockState state = context.state;
            SuperByteBuffer superBuffer = CachedBuffers.partial((PartialModel)AllPartialModels.DRILL_HEAD, (BlockState)state);
            Direction facing = (Direction)state.getValue((Property)DrillBlock.FACING);
            SheetedDecalTextureGenerator consumer = new SheetedDecalTextureGenerator(buffer.getBuffer(CustomRenderType.Companion.getGLINT()), matrices.getViewProjection().last(), 0.0078125f);
            float speed = context.contraption.stalled || !VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)facing.getOpposite()) ? context.getAnimationSpeed() : 0.0f;
            float time = AnimationTickHolder.getRenderTime() / (float)20;
            float angle = time * speed % (float)360;
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)superBuffer.transform(matrices.getModel())).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing))).rotateXDegrees(AngleHelper.verticalAngle((Direction)facing))).rotateZDegrees(angle)).uncenter()).light(LevelRenderer.getLightColor((BlockAndTintGetter)((BlockAndTintGetter)renderWorld), (BlockPos)context.localPos)).useLevelLight((BlockAndTintGetter)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), (VertexConsumer)consumer);
            PoseStack poseStack = matrices.getModelViewProjection();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"getModelViewProjection(...)");
            PoseStackUtilKt.use((PoseStack)poseStack, () -> Companion.renderInContraption$lambda$0(matrices, context, consumer));
        }

        private static final Unit renderInContraption$lambda$0(ContraptionMatrices $matrices, MovementContext $context, SheetedDecalTextureGenerator $consumer) {
            TransformStack.of((PoseStack)$matrices.getModelViewProjection()).translate((Vec3i)$context.localPos);
            Minecraft.getInstance().getBlockRenderer().renderBatched($context.state, $context.localPos, (BlockAndTintGetter)$context.world, $matrices.getModelViewProjection(), (VertexConsumer)$consumer, true, RANDOM);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

