/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.net;

import de.maxhenkel.voicechat.net.Packet;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class PlayerStatesPacket
implements Packet<PlayerStatesPacket> {
    public static final CustomPacketPayload.Type<PlayerStatesPacket> PLAYER_STATES = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"voicechat", (String)"player_states"));
    private Map<UUID, PlayerState> playerStates;

    public PlayerStatesPacket() {
    }

    public PlayerStatesPacket(Map<UUID, PlayerState> playerStates) {
        this.playerStates = playerStates;
    }

    public Map<UUID, PlayerState> getPlayerStates() {
        return this.playerStates;
    }

    @Override
    public PlayerStatesPacket fromBytes(FriendlyByteBuf buf) {
        this.playerStates = new HashMap<UUID, PlayerState>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            PlayerState playerState = PlayerState.fromBytes(buf);
            this.playerStates.put(playerState.getUuid(), playerState);
        }
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.playerStates.size());
        for (Map.Entry<UUID, PlayerState> entry : this.playerStates.entrySet()) {
            entry.getValue().toBytes(buf);
        }
    }

    @Override
    public CustomPacketPayload.Type<PlayerStatesPacket> type() {
        return PLAYER_STATES;
    }
}

