/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.observer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkBlock;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.observer.TrackObserver;
import com.simibubi.create.content.trains.observer.TrackObserverBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TrackObserverBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity {
    public TrackTargetingBehaviour<TrackObserver> edgePoint;
    private FilteringBehaviour filtering;

    public TrackObserverBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour<TrackObserver>(this, EdgePointType.OBSERVER);
        behaviours.add(this.edgePoint);
        this.filtering = this.createFilter().withCallback(this::onFilterChanged);
        behaviours.add(this.filtering);
        this.filtering.setLabel(CreateLang.translateDirect("logistics.train_observer.cargo_filter", new Object[0]));
    }

    private void onFilterChanged(ItemStack newFilter) {
        if (this.level.isClientSide()) {
            return;
        }
        TrackObserver observer = this.getObserver();
        if (observer != null) {
            observer.setFilterAndNotify(this.level, newFilter);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            return;
        }
        boolean shouldBePowered = false;
        TrackObserver observer = this.getObserver();
        if (observer != null) {
            shouldBePowered = observer.isActivated();
        }
        if (this.isBlockPowered() == shouldBePowered) {
            return;
        }
        BlockState blockState = this.getBlockState();
        if (blockState.hasProperty((Property)TrackObserverBlock.POWERED)) {
            this.level.setBlock(this.worldPosition, (BlockState)blockState.setValue((Property)TrackObserverBlock.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)), 3);
        }
        DisplayLinkBlock.notifyGatherers((LevelAccessor)this.level, this.worldPosition);
    }

    @Nullable
    public TrackObserver getObserver() {
        return this.edgePoint.getEdgePoint();
    }

    public ItemStack getFilter() {
        return this.filtering.getFilter();
    }

    public boolean isBlockPowered() {
        return this.getBlockState().getOptionalValue((Property)TrackObserverBlock.POWERED).orElse(false);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(Vec3.atLowerCornerOf((Vec3i)this.worldPosition), Vec3.atLowerCornerOf((Vec3i)this.edgePoint.getGlobalPosition())).inflate(2.0);
    }

    @Override
    public void transform(BlockEntity be, StructureTransform transform) {
        this.edgePoint.transform(be, transform);
    }

    public FilteringBehaviour createFilter() {
        return new FilteringBehaviour(this, new ValueBoxTransform(this){

            @Override
            public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
                TransformStack.of((PoseStack)ms).rotateXDegrees(90.0f);
            }

            @Override
            public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
                return new Vec3(0.5, 0.96875, 0.5);
            }
        });
    }
}

