/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ProcessingOutput {
    public static final ProcessingOutput EMPTY = new ProcessingOutput(ItemStack.EMPTY, 1.0f);
    public static final StreamCodec<RegistryFriendlyByteBuf, ProcessingOutput> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), i -> i.item, (StreamCodec)ByteBufCodecs.INT, i -> i.count, (StreamCodec)DataComponentPatch.STREAM_CODEC, i -> i.patch, (StreamCodec)ByteBufCodecs.FLOAT, i -> Float.valueOf(i.chance), ProcessingOutput::new);
    private static final Random r = new Random();
    private final Item item;
    private final int count;
    private final DataComponentPatch patch;
    private final float chance;
    private ResourceLocation datagenOutput;
    @Deprecated(forRemoval=true)
    private static final Codec<Either<ItemStack, Pair<ResourceLocation, Integer>>> ITEM_CODEC_OLD = Codec.either((Codec)ItemStack.SINGLE_ITEM_CODEC, (Codec)ResourceLocation.CODEC.comapFlatMap(loc -> DataResult.error(() -> "Compat cannot be deserialized"), Pair::getFirst));
    @Deprecated(forRemoval=true)
    public static final Codec<ProcessingOutput> CODEC_OLD = RecordCodecBuilder.create(i -> i.group((App)ITEM_CODEC_OLD.fieldOf("item").forGetter(s -> s.datagenOutput != null ? Either.right((Object)Pair.of((Object)s.datagenOutput, (Object)s.count)) : Either.left((Object)s.item.getDefaultInstance())), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(s -> s.count), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(s -> Float.valueOf(s.chance))).apply((Applicative)i, (item, count, chance) -> (ProcessingOutput)item.map(stack -> new ProcessingOutput(stack.getItem(), (int)count, stack.getComponentsPatch(), chance.floatValue()), compat -> new ProcessingOutput((ResourceLocation)compat.getFirst(), (int)((Integer)compat.getSecond()), chance.floatValue()))));
    private static final Codec<Either<Item, ResourceLocation>> ITEM_CODEC = Codec.either((Codec)BuiltInRegistries.ITEM.byNameCodec(), (Codec)ResourceLocation.CODEC);
    public static final Codec<ProcessingOutput> CODEC_NEW = RecordCodecBuilder.create(i -> i.group((App)ITEM_CODEC.fieldOf("id").forGetter(s -> {
        if (s.datagenOutput != null) {
            return Either.right((Object)s.datagenOutput);
        }
        return Either.left((Object)s.item);
    }), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(s -> s.count), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(s -> s.patch), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(s -> Float.valueOf(s.chance))).apply((Applicative)i, (item, count, components, chance) -> (ProcessingOutput)item.map(stack -> new ProcessingOutput((Item)stack, (int)count, (DataComponentPatch)components, chance.floatValue()), compat -> new ProcessingOutput((ResourceLocation)compat, (int)count, chance.floatValue()))));
    public static final Codec<ProcessingOutput> CODEC = Codec.withAlternative(CODEC_NEW, CODEC_OLD);

    public ProcessingOutput(ItemStack stack, float chance) {
        this(stack.getItem(), stack.getCount(), stack.getComponentsPatch(), chance);
    }

    public ProcessingOutput(Item item, int count, float chance) {
        this(item, count, DataComponentPatch.EMPTY, chance);
    }

    public ProcessingOutput(Item item, int count, DataComponentPatch patch, float chance) {
        this.item = item;
        this.count = count;
        this.patch = patch;
        this.chance = chance;
    }

    public ProcessingOutput(ResourceLocation item, int count, float chance) {
        this.item = Items.AIR;
        this.datagenOutput = item;
        this.count = count;
        this.patch = DataComponentPatch.EMPTY;
        this.chance = chance;
    }

    public ItemStack getStack() {
        return new ItemStack((ItemLike)(this.datagenOutput != null ? (ItemLike)BuiltInRegistries.ITEM.get(this.datagenOutput) : this.item), this.count);
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack rollOutput() {
        int outputAmount = this.count;
        for (int roll = 0; roll < this.count; ++roll) {
            if (!(r.nextFloat() > this.chance)) continue;
            --outputAmount;
        }
        if (outputAmount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack out = this.item.getDefaultInstance();
        out.setCount(outputAmount);
        return out;
    }
}

