/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderInfoManager;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import net.createmod.catnip.render.ShadedBlockSbbBuilder;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.Pair;

public class ContraptionRenderInfo {
    public static final SuperByteBufferCache.Compartment<Pair<Contraption, RenderType>> CONTRAPTION = new SuperByteBufferCache.Compartment();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private final Contraption contraption;
    private final VirtualRenderWorld renderWorld;
    private final ContraptionMatrices matrices = new ContraptionMatrices();

    ContraptionRenderInfo(Level level, Contraption contraption) {
        this.contraption = contraption;
        this.renderWorld = ContraptionRenderInfo.setupRenderWorld(level, contraption);
    }

    public static ContraptionRenderInfo get(Contraption contraption) {
        return ((ContraptionRenderInfoManager)ContraptionRenderInfoManager.MANAGERS.get((LevelAccessor)contraption.entity.level())).getRenderInfo(contraption);
    }

    public static boolean invalidate(Contraption contraption) {
        return ((ContraptionRenderInfoManager)ContraptionRenderInfoManager.MANAGERS.get((LevelAccessor)contraption.entity.level())).invalidate(contraption);
    }

    public boolean isDead() {
        return !this.contraption.entity.isAliveOrStale();
    }

    public Contraption getContraption() {
        return this.contraption;
    }

    public VirtualRenderWorld getRenderWorld() {
        return this.renderWorld;
    }

    public ContraptionMatrices getMatrices() {
        return this.matrices;
    }

    public SuperByteBuffer getBuffer(RenderType renderType) {
        return SuperByteBufferCache.getInstance().get(CONTRAPTION, (Object)Pair.of((Object)this.contraption, (Object)renderType), () -> this.buildStructureBuffer(renderType));
    }

    public void invalidate() {
        for (RenderType renderType : RenderType.chunkBufferLayers()) {
            SuperByteBufferCache.getInstance().invalidate(CONTRAPTION, (Object)Pair.of((Object)this.contraption, (Object)renderType));
        }
    }

    public static VirtualRenderWorld setupRenderWorld(Level level, final Contraption c) {
        ContraptionWorld contraptionWorld = c.getContraptionWorld();
        BlockPos origin = c.anchor;
        int minBuildHeight = contraptionWorld.getMinBuildHeight();
        int height = contraptionWorld.getHeight();
        VirtualRenderWorld renderWorld = new VirtualRenderWorld(level, minBuildHeight, height, (Vec3i)origin){

            public boolean supportsVisualization() {
                return VisualizationManager.supportsVisualization((LevelAccessor)this.level);
            }

            public ModelData getModelData(BlockPos pos) {
                return c.modelData.getOrDefault(pos, ModelData.EMPTY);
            }
        };
        renderWorld.setBlockEntities(c.presentBlockEntities.values());
        for (StructureTemplate.StructureBlockInfo info : c.getBlocks().values()) {
            renderWorld.setBlock(info.pos(), info.state(), 0);
        }
        renderWorld.runLightEngine();
        return renderWorld;
    }

    private SuperByteBuffer buildStructureBuffer(RenderType layer) {
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        ModelBlockRenderer renderer = dispatcher.getModelRenderer();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        PoseStack poseStack = objects.poseStack;
        RandomSource random = objects.random;
        Contraption.RenderedBlocks blocks = this.contraption.getRenderedBlocks();
        ShadedBlockSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.begin();
        ModelBlockRenderer.enableCaching();
        for (BlockPos pos : blocks.positions()) {
            BlockState state = blocks.lookup().apply(pos);
            if (state.getRenderShape() != RenderShape.MODEL) continue;
            BakedModel model = dispatcher.getBlockModel(state);
            ModelData modelData = model.getModelData((BlockAndTintGetter)this.renderWorld, pos, state, this.renderWorld.getModelData(pos));
            long randomSeed = state.getSeed(pos);
            random.setSeed(randomSeed);
            if (!model.getRenderTypes(state, random, modelData).contains(layer)) continue;
            poseStack.pushPose();
            poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            renderer.tesselateBlock((BlockAndTintGetter)this.renderWorld, model, state, pos, poseStack, (VertexConsumer)sbbBuilder, true, random, randomSeed, OverlayTexture.NO_OVERLAY, modelData, layer);
            poseStack.popPose();
        }
        ModelBlockRenderer.clearCache();
        return sbbBuilder.end();
    }

    private static class ThreadLocalObjects {
        public final PoseStack poseStack = new PoseStack();
        public final RandomSource random = RandomSource.createNewThreadLocalInstance();
        public final ShadedBlockSbbBuilder sbbBuilder = ShadedBlockSbbBuilder.create();

        private ThreadLocalObjects() {
        }
    }
}

