/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.Create;
import com.simibubi.create.api.contraption.ContraptionType;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.registry.CreateRegistries;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class AllTags {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.create((ResourceKey)registry.key(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> commonTag(Registry<T> registry, String path) {
        return AllTags.optionalTag(registry, ResourceLocation.fromNamespaceAndPath((String)"c", (String)path));
    }

    public static TagKey<Block> commonBlockTag(String path) {
        return AllTags.commonTag(BuiltInRegistries.BLOCK, path);
    }

    public static TagKey<Item> commonItemTag(String path) {
        return AllTags.commonTag(BuiltInRegistries.ITEM, path);
    }

    public static TagKey<Fluid> commonFluidTag(String path) {
        return AllTags.commonTag(BuiltInRegistries.FLUID, path);
    }

    public static void init() {
        AllBlockTags.init();
        AllItemTags.init();
        AllFluidTags.init();
        AllEntityTags.init();
        AllRecipeSerializerTags.init();
        AllContraptionTypeTags.init();
        AllMountedItemStorageTypeTags.init();
    }

    public static enum AllBlockTags {
        BRITTLE,
        CASING,
        COPYCAT_ALLOW,
        COPYCAT_DENY,
        FAN_PROCESSING_CATALYSTS_BLASTING(NameSpace.MOD, "fan_processing_catalysts/blasting"),
        FAN_PROCESSING_CATALYSTS_HAUNTING(NameSpace.MOD, "fan_processing_catalysts/haunting"),
        FAN_PROCESSING_CATALYSTS_SMOKING(NameSpace.MOD, "fan_processing_catalysts/smoking"),
        FAN_PROCESSING_CATALYSTS_SPLASHING(NameSpace.MOD, "fan_processing_catalysts/splashing"),
        FAN_TRANSPARENT,
        GIRDABLE_TRACKS,
        MOVABLE_EMPTY_COLLIDER,
        NON_MOVABLE,
        NON_BREAKABLE,
        ORE_OVERRIDE_STONE,
        PASSIVE_BOILER_HEATERS,
        SAFE_NBT,
        SEATS,
        POSTBOXES,
        TABLE_CLOTHS,
        TOOLBOXES,
        TRACKS,
        TREE_ATTACHMENTS,
        VALVE_HANDLES,
        WINDMILL_SAILS,
        WRENCH_PICKUP,
        CHEST_MOUNTED_STORAGE,
        SIMPLE_MOUNTED_STORAGE,
        FALLBACK_MOUNTED_STORAGE_BLACKLIST,
        ROOTS,
        SUGAR_CANE_VARIANTS,
        NON_HARVESTABLE,
        SINGLE_BLOCK_INVENTORIES,
        CORALS,
        RELOCATION_NOT_SUPPORTED(NameSpace.COMMON),
        SLIMY_LOGS(NameSpace.TIC),
        NON_DOUBLE_DOOR(NameSpace.QUARK);

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private AllBlockTags() {
            this(NameSpace.MOD);
        }

        private AllBlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllBlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllBlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? AllTags.optionalTag(BuiltInRegistries.BLOCK, id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.getItem()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).getBlock());
        }

        public boolean matches(BlockState state) {
            return state.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum AllItemTags {
        BLAZE_BURNER_FUEL_REGULAR(NameSpace.MOD, "blaze_burner_fuel/regular"),
        BLAZE_BURNER_FUEL_SPECIAL(NameSpace.MOD, "blaze_burner_fuel/special"),
        CASING,
        CONTRAPTION_CONTROLLED,
        CREATE_INGOTS,
        CRUSHED_RAW_MATERIALS,
        DIVING_ARMOR,
        INVALID_FOR_TRACK_PAVING,
        DEPLOYABLE_DRINK,
        PRESSURIZED_AIR_SOURCES,
        SANDPAPER,
        SEATS,
        POSTBOXES,
        TABLE_CLOTHS,
        DYED_TABLE_CLOTHS,
        PULPIFIABLE,
        SLEEPERS,
        TOOLBOXES,
        PACKAGES,
        CHAIN_RIDEABLE,
        TRACKS,
        UPRIGHT_ON_BELT,
        VALVE_HANDLES,
        DISPENSE_BEHAVIOR_WRAP_BLACKLIST,
        PLATES(NameSpace.COMMON),
        OBSIDIAN_DUST(NameSpace.COMMON, "dusts/obsidian"),
        WRENCH(NameSpace.COMMON, "tools/wrench"),
        ALLURITE(NameSpace.MOD, "stone_types/galosphere/allurite"),
        AMETHYST(NameSpace.MOD, "stone_types/galosphere/amethyst"),
        LUMIERE(NameSpace.MOD, "stone_types/galosphere/lumiere"),
        UA_CORAL(NameSpace.MOD, "upgrade_aquatic/coral"),
        CURIOS_HEAD(NameSpace.CURIOS, "head");

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private AllItemTags() {
            this(NameSpace.MOD);
        }

        private AllItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? AllTags.optionalTag(BuiltInRegistries.ITEM, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.builtInRegistryHolder().is(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum AllFluidTags {
        BOTTOMLESS_ALLOW(NameSpace.MOD, "bottomless/allow"),
        BOTTOMLESS_DENY(NameSpace.MOD, "bottomless/deny"),
        FAN_PROCESSING_CATALYSTS_BLASTING(NameSpace.MOD, "fan_processing_catalysts/blasting"),
        FAN_PROCESSING_CATALYSTS_HAUNTING(NameSpace.MOD, "fan_processing_catalysts/haunting"),
        FAN_PROCESSING_CATALYSTS_SMOKING(NameSpace.MOD, "fan_processing_catalysts/smoking"),
        FAN_PROCESSING_CATALYSTS_SPLASHING(NameSpace.MOD, "fan_processing_catalysts/splashing");

        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;

        private AllFluidTags() {
            this(NameSpace.MOD);
        }

        private AllFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? AllTags.optionalTag(BuiltInRegistries.FLUID, id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Fluid fluid) {
            return fluid.is(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum AllEntityTags {
        BLAZE_BURNER_CAPTURABLE,
        IGNORE_SEAT;

        public final TagKey<EntityType<?>> tag;
        public final boolean alwaysDatagen;

        private AllEntityTags() {
            this(NameSpace.MOD);
        }

        private AllEntityTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllEntityTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllEntityTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllEntityTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? AllTags.optionalTag(BuiltInRegistries.ENTITY_TYPE, id) : TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(EntityType<?> type) {
            return type.is(this.tag);
        }

        public boolean matches(Entity entity) {
            return this.matches(entity.getType());
        }

        private static void init() {
        }
    }

    public static enum AllRecipeSerializerTags {
        AUTOMATION_IGNORE;

        public final TagKey<RecipeSerializer<?>> tag;
        public final boolean alwaysDatagen;

        private AllRecipeSerializerTags() {
            this(NameSpace.MOD);
        }

        private AllRecipeSerializerTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllRecipeSerializerTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllRecipeSerializerTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllRecipeSerializerTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)namespace.id, (String)(path == null ? Lang.asId((String)this.name()) : path));
            this.tag = optional ? AllTags.optionalTag(BuiltInRegistries.RECIPE_SERIALIZER, id) : TagKey.create((ResourceKey)Registries.RECIPE_SERIALIZER, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(RecipeSerializer<?> recipeSerializer) {
            ResourceKey key = (ResourceKey)BuiltInRegistries.RECIPE_SERIALIZER.getResourceKey(recipeSerializer).orElseThrow();
            return ((Holder.Reference)BuiltInRegistries.RECIPE_SERIALIZER.getHolder(key).orElseThrow()).is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum AllContraptionTypeTags {
        OPENS_CONTROLS,
        REQUIRES_VEHICLE_FOR_RENDER;

        public final TagKey<ContraptionType> tag;
        public final boolean alwaysDatagen;

        private AllContraptionTypeTags() {
            ResourceLocation tagId = Create.asResource(Lang.asId((String)this.name()));
            this.tag = TagKey.create(CreateRegistries.CONTRAPTION_TYPE, (ResourceLocation)tagId);
            this.alwaysDatagen = true;
        }

        public boolean matches(ContraptionType type) {
            return type.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum AllMountedItemStorageTypeTags {
        INTERNAL,
        FUEL_BLACKLIST;

        public final TagKey<MountedItemStorageType<?>> tag;
        public final boolean alwaysDatagen;

        private AllMountedItemStorageTypeTags() {
            ResourceLocation tagId = Create.asResource(Lang.asId((String)this.name()));
            this.tag = TagKey.create(CreateRegistries.MOUNTED_ITEM_STORAGE_TYPE, (ResourceLocation)tagId);
            this.alwaysDatagen = true;
        }

        public boolean matches(MountedItemStorage storage) {
            return this.matches(storage.type);
        }

        public boolean matches(MountedItemStorageType<?> type) {
            return type.is(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("create", false, true),
        COMMON("c"),
        TIC("tconstruct"),
        QUARK("quark"),
        GS("galosphere"),
        CURIOS("curios");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

